/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

#include <CbfHash.h>

#ifndef CbfClean_h
#define CbfClean_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define CBFCLEAN_MAX 128
typedef void *(*CbfCleanFnt_t)(void *);
typedef void (*CbfCleanExitFnt_t)(void);
typedef int (*CbfCleanPrinter_t) (const char* format, va_list args);

typedef struct CbfCleanChain {
  char name[CBFCLEAN_MAX];
  CbfCleanFnt_t function;
  void *arg;
  int  loop;
  struct CbfClean *cleanRef;
  struct CbfCleanChain *next;
} CbfCleanChain_t;

typedef struct CbfClean {
  CbfCleanChain_t *chain;
  char name[CBFCLEAN_MAX];
  pthread_mutex_t mutex;
} CbfClean_t;


extern CbfCleanChain_t *CbfCleanAdd( CbfClean_t *clean, char *fName,
				     CbfCleanFnt_t function, void *arg );
#define CbfCleanAddRoot( fName, function, arg ) \
        CbfCleanAdd((CbfClean_t*)NULL, fName, function, arg)
extern int CbfCleanDone( char *fName, void *arg );
extern CbfCleanChain_t *CbfCleanFind( char *fName, void *arg );
extern CbfClean_t *CbfCleanFree( CbfClean_t *clean );
extern CbfClean_t *CbfCleanFreeTag( char *fName, void *arg );
extern CbfCleanPrinter_t CbfCleanInstallPrinter( CbfCleanPrinter_t printer );
extern CbfClean_t *CbfCleanNew( char *name );
extern void CbfCleanPrint( CbfClean_t *clean, char *format, ... );
extern void CbfCleanSetDebug( int debug, char *name );
extern CbfCleanExitFnt_t CbfCleanSetExitFnt( CbfCleanExitFnt_t exitFnt );
extern int CbfCleanFinished(void);
extern void CbfTerminate(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CbfSearch_h */
