/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

#include <sys/types.h>
#include <stdarg.h>
#include <pthread.h>
#include <CbfHeader.h>

#ifndef CbfHash_h
#define CbfHash_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define CBFHROOT -1
typedef int (*CbfHPrinter_t) (const char* format, va_list args);

typedef struct CbfHEntry {
  char *key;
  char *data;
  struct CbfHEntry *next; 
} CbfHEntry_t;

typedef struct CbfH {
  CbfHEntry_t **entry;
  int nElem;
  pthread_mutex_t mutex;
} CbfH_t;

extern CbfHEntry_t *CbfHEnter(  CbfH_t *hTable, char *key, void *data );
#define CbfHEnterRoot( k, d ) CbfHEnter( (CbfH_t*)NULL, k, d)
extern void CbfHEntryRemove( CbfHEntry_t *entry );
extern CbfHEntry_t *CbfHFind( CbfH_t *hTable, char *key );
#define CbfHFindRoot( k ) CbfHFind( (CbfH_t*)NULL, k)
extern CbfH_t *CbfHFree( CbfH_t *hTable );
extern CbfHPrinter_t CbfHInstallPrinter( CbfHPrinter_t printer );
extern CbfH_t *CbfHNew( int nElem );
extern void _CbfHPrint(  CbfH_t *hTable, char *tag );
extern void CbfHPrint( CbfH_t *hTable );

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CbfHash_h */
