/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

#ifndef CbfHeader_h
#define CbfHeader_h

#ifdef __cplusplus
extern "C" { 
#endif /* __cplusplus */

#ifndef XSTR
#define XSTR(s) STR(s)
#define STR(s)  #s
#endif /* XSTR */

/* FCA, Removed ifndef __GNUC__ to make Cfg compilable on Linux-x86_64 (300 Gf Farm machines) */
/* ------------------------------------------------------------------------------ See SPR #313*/
/* #ifndef __GNUC__ */
#define __FUNCTION__ __FILE__ ", line " XSTR(__LINE__)
/* #endif  __GNUC__ */

#define CBF_OK        0
#define CBF_FAIL     -1
#define CBF_EXIT     -2
#define CBF_CONTINUE -3

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CbfHeader_h */
