/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

#include <CbfClean.h>
#include <CfgHeader.h>
#include <CfgList.h>
#include <CfgMsg.h>
#include <CfgOut.h>
#include <stdio.h>

#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

/**************************************************************/
#ifndef CFGCOMMON_H
#define CFGCOMMON_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef __STRICT_ANSI__
#define asm    __asm__
#define inline __inline__
#endif /*---------------------------------------------------- __STRICT_ANSI__ */

/**************************************************************/
#define CFG_TIME_FMT        "%Y-%m-%d-%Hh%Mm%S-UTC"
#define CFG_PERIOD          1

typedef enum {
  CfgServerUnknow = -1,
  CfgServerIdle,
  CfgServerConfigured,
  CfgServerActive,
  CfgServerGolden,
  CfgServerError,
  CfgServerEnd
} CfgServerState_t ;

typedef int (*CfgStateReachFnt_t) (void *p);
typedef char *(*CfgStateStrFnt_t) (int state);
typedef void (*CfgConfigFnt_t) (void);


/*----------------------------------------------------------------------------*/
typedef enum {
  CFGSEND = -1,
  CFGDBGCM=2,
  CFGDBGMAX=1000
} CfgDebug_t;

#define CFG_CLINFO -1

/**************************************************************/
/* global variables */
typedef struct CfgData CfgData_t;
typedef char *(*CfgUserActivationGetFnt_t) ( void *param );

/**************************************************************/
/* function prototypes */

extern char *CfgBasename( const char *filename );
extern char *CfgCmName( int argc, char *argv[] );
extern char *CfgDirname( char *path );
extern char *CfgFindPath( char *filename, size_t len, char *pname, int mode );
extern char *CfgFindPathExec( char *filename, size_t len, char *pname );
extern size_t CfgGetDataSize( const char *path, int pid, size_t *freemem );
extern char *CfgRunTimeStrBuilt( time_t startTime, char *runTime, size_t len );
extern char *CfgStrRemove( char *str, char *del, char sep );
extern char *CfgStrFmtCat( char *str, CfgBool_t uniq, char *format, ... );
extern char *CfgStrFmtCatv( char *str, CfgBool_t uniq, char *format,
			    va_list args );
extern char *CfgSubSysName( int argc, char *argv[] );
extern char *CfgTolower( char *str );
extern char *CfgToupper( char *str );
extern int  CfgWaitWithTimeout( double tmo );

extern int CfgDataCloseLogStream( CfgData_t *p, int closeFlag );
extern int CfgDataConfAddv( CfgData_t *p, char *fmt, va_list args );
extern char *CfgDataGetActivation( CfgData_t *p );
extern double CfgDataGetCmCleanupTmo( CfgData_t *p );
extern char *CfgDataGetCmDomainName( CfgData_t *p );
extern char *CfgDataGetCmName( CfgData_t *p );
extern int CfgDataGetCommitFlag( CfgData_t *p, int *File, int *db );
extern char *CfgDataGetConfig( CfgData_t *p );
extern time_t CfgDataGetConfigTime( CfgData_t *p );
extern time_t CfgDataGetCurrentTime( CfgData_t *p );
extern int  CfgDataGetDebug( CfgData_t *p );
extern char *CfgDataGetHostname( CfgData_t *p );
extern char *CfgDataGetLogFilename( CfgData_t *p );
extern FILE *CfgDataGetLogStream( CfgData_t *p);
extern size_t CfgDataGetMemSize( CfgData_t *p );
extern CfgMsgR_t *CfgDataGetMsgR( CfgData_t *p );
extern int CfgDataGetPid( CfgData_t *p );
extern CfgServerState_t CfgDataGetRequestedState( CfgData_t *p );
extern int CfgDataGetRFlag( CfgData_t *p, int *log, int *stdOut, int *cmTrace );
extern CfgServerState_t CfgDataGetState( CfgData_t *p );
extern char *CfgDataGetStateStr( CfgData_t *p, CfgServerState_t state );
extern time_t CfgDataGetStartTime( CfgData_t *p );
extern char *CfgDataGetStrTime( CfgData_t *p );
extern char *CfgDataGetSysName( CfgData_t *p );
extern char *CfgDataGetTag( CfgData_t *p );
extern char *CfgDataGetUserActivation( CfgData_t *p ); 
extern CfgData_t *CfgDataFree( CfgData_t *p );
extern int CfgDataLogFilenameInit( CfgData_t *p );
extern int CfgDataLogFPrintv( CfgData_t *p, char *fmt, va_list args );
extern int CfgDataLogFPrint( CfgData_t *p, char *fmt, ... );
extern int CfgDataMsgAddFmtv( CfgData_t *p,  int errLvl, int debug, char *tag,
			      char *fmt, va_list args );
extern int CfgDataMsgLogReportClose( CfgData_t *p );
extern int CfgDataMsgLogReportOpen( CfgData_t *p );
extern int CfgDataMsgRSend( CfgData_t *p, double tmo  );
extern int CfgDataMsgSendInit( CfgData_t *p, const CfgMsg_t *msg );
extern int CfgDataMsgSendLog( CfgData_t *p, const CfgMsg_t *msg );
extern int CfgDataMsgSendStdout( CfgData_t *p, const CfgMsg_t *msg );
extern CfgData_t *CfgDataNew( int argc, char *argv[], int msgNb );
extern int  CfgDataOpenLogStream( CfgData_t *p );
extern int CfgDataReachState( CfgData_t *p, CfgServerState_t state ); 
extern int CfgDataSetCmCleanupTmo( CfgData_t *p, double tmo );
extern int CfgDataSetCmDomainName( CfgData_t *p, char *cmDomain );
extern int CfgDataSetConfig( CfgData_t *p, char *buffer);
extern CfgConfigFnt_t CfgDataSetConfigFnt( CfgData_t *p,
					   CfgConfigFnt_t configFnt );
extern int CfgDataSetDebug( CfgData_t *p, int debug );
extern int CfgDataSetNoDbSave( CfgData_t *p, int val );
extern int CfgDataSetNoFileSave( CfgData_t *p, int val );
extern int CfgDataSetPeriodTime( CfgData_t *p, double period );
extern int CfgDataSetPrio( CfgData_t *p, int prio );
extern int CfgDataSetRFlag( CfgData_t *p, int log, int stdOut, int cmTrace );
extern int CfgDataSetSchedAffinity( CfgData_t *p, char *schedAffinity );
extern int CfgDataSetStateFnt( CfgData_t *p, int cState, int rState,
			       CfgStateReachFnt_t f, void *q );
extern void CfgDataSetStateStrFnt( CfgData_t *p, CfgStateStrFnt_t stateFnt );
extern int CfgDataSetUserActivationFnt( CfgData_t *p,
					CfgUserActivationGetFnt_t userActFnt,
					void *param );

typedef struct CfgPrinter CfgPrinter_t;
extern int CfgDataMsgPrinterv( CfgData_t *p, char *format, va_list args );

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CFGCOMMON_H */
