/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

#include <stdio.h>
#include <stdlib.h>
#include <CfgVirgo.h>


/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*---------------------------------------------------------------- CfgDbUsage */
/*----------------------------------------------------------------------------*/
void CfgDbUsage( void ) {
  /*--------------------------------------------------------------------------*/
  printf("CfgDb usage:\n");
  printf("  CfgDb <dbTag> <filenane>.<extension>: load the <dbTag> DbObject "
	 "content in the <filename>.<extension> file\n" );
  printf("  CfgDb <filename>.<extension> <dbTag>: Commit the <filename>."
	 "<extension> content in the <dbTag> DbObject\n\n");
  exit( EXIT_FAILURE );
  /*--------------------------------------------------------------------------*/
  return;
}


/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int main( int argc, char *argv[] ) {
  CfgData_t  *cfg;

  if( (argc != 3) || 
      (CfgFromFile( argv[1] ) == CfgFromFile( argv[2] )) ) CfgDbUsage();
  /*------------------------------------------------------- Cm Initialization */
  if( !CmMessageOpenMultipleServer(CfgBasename(argv[0])) ) {
    fprintf( stderr, "%s> CmMessageOpenMultipleServer failed\n", 
	     CfgBasename(argv[0]));
    exit( EXIT_FAILURE );
  }
  cfg = CfgDataNew( 0, NULL, 0 ); 
  /*------------------------------------------ Fill the CfgData strTime field */
  CfgDataGetStartTime( cfg );
  CbfCleanInstallPrinter((CbfCleanPrinter_t)NULL);

  /*--------------------------------------------------------------------------*/
  if( CfgFromFile( argv[1] ) ) { /*---------- Load from file and commit to Db */
    CfgConfigLoad( argv[1] ); 
    CfgDataSetNoFileSave( cfg, CfgTrue );
    CfgConfigCommit( argv[2] );
  }
  if( CfgFromFile( argv[2] ) ) { /*---------- Load from Db and commit to file */
    CfgConfigLoad( argv[1] );
    CfgDataSetNoDbSave( cfg, CfgTrue ); 
    CfgConfigCommit( argv[2] );
  }
  /*--------------------------------------------------------------------------*/
  exit( EXIT_SUCCESS );
}
