/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

#include <CbfHeader.h>

#ifndef CfgHeader_h
#define CfgHeader_h

#ifdef __cplusplus
extern "C" { 
#endif /* __cplusplus */

#ifdef CFG_DBG
#define CFG_DEBUG(x)  printf x
#else   
#define CFG_DEBUG(x)
#endif /* CFG_DBG */

#define CFG_OK       CBF_OK
#define CFG_FAIL     CBF_FAIL
#define CFG_EXIT     CBF_EXIT 
#define CFG_CONTINUE CBF_CONTINUE

typedef unsigned long Ulong;

typedef enum CfgBool{
  CfgFalse = 0,
  CfgTrue,
  CfgUnknown
} CfgBool_t;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CfgHeader_h */
