/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

#include <CbfHash.h>
#include <CfgHeader.h>

/**************************************************************/
#ifndef CFGMSG_H
#define CFGMSG_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef enum {
  CFG_INFO=0,               /* information (or unknown type) */
  CFG_WARNING=1,            /* program warning */
  CFG_ERROR=2,              /* program error */
  CFG_FATAL=3,              /* fatal error (requests program exit) */
  CFG_USER_INFO=4,          /* user information */
  CFG_MSGLVL_MAX            /* number of message levels */
} CfgMsgLvl_t;

#define CFG_MSG_BUF_SIZE  4096
typedef int (*CfgMsgPrinter_t) (const char* format, va_list args);
extern CfgMsgPrinter_t CfgMsgInstallPrinter( CfgMsgPrinter_t printer );

/*---------------------------------------- error message structure definition */
typedef struct CfgMsg CfgMsg_t;
extern int CfgMsgGetCount( const CfgMsg_t *p );
extern int CfgMsgGetLevel( const CfgMsg_t *p );
extern const char *CfgMsgGetLevelStr( const CfgMsg_t *p );
extern time_t CfgMsgGetTimeStamp( const CfgMsg_t *p );
extern const struct tm *CfgMsgGetTimeStampTm( const CfgMsg_t *p );
extern char *CfgMsgGetTxt( const CfgMsg_t *p );
extern CfgMsg_t * CfgMsgFree( CfgMsg_t *p );
extern CfgMsg_t *CfgMsgNew( int level, const char *msg );
extern CfgMsg_t *CfgMsgNewArgs( int level, char *fmt, va_list args );
extern CfgMsg_t *CfgMsgNewFmt( int level, char *fmt, ... );

extern void CfgMsgPrintv( int level, char *fmt, va_list args );
/*---------------------------------------- error message reporter definition */
typedef struct CfgMsgR CfgMsgR_t;
typedef int (CfgMsgSendFnt_t)( void *p, const CfgMsg_t *msg );
typedef int (CfgMsgFnt_t)( void *p );

extern int CfgMsgRAddFnt( CfgMsgR_t *p, CfgMsgSendFnt_t *fSend,  void *q, 
			  CfgMsgFnt_t *fPre, CfgMsgFnt_t *fPost );
extern int CfgMsgRAddMsg( CfgMsgR_t  *p, CfgMsg_t *msg );
extern int CfgMsgRAddMsgTag( CfgMsgR_t  *p, CfgMsg_t *msg, char *tag );
extern CfgMsgR_t *CfgMsgRFree( CfgMsgR_t *p );
extern CfgMsgR_t *CfgMsgRNew( int nbMsg );
extern int CfgMsgRRmFnt( CfgMsgR_t *p, CfgMsgSendFnt_t *f, void *q, 
			  CfgMsgFnt_t *fPre, CfgMsgFnt_t *fPost );
extern int CfgMsgRSend( CfgMsgR_t *p, const CfgMsg_t *uiMsg );

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
