/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

#include <CfgHeader.h>
#include <CmMessage.h>
#include <CfgParse.h>

#ifndef CfgOut_h
#define CfgOut_h

#ifdef __cplusplus
extern "C" { 
#endif /* __cplusplus */

typedef enum CfgOutStatus {
  CfgOutNone = 0,
  CfgOutUnknownByNS,
  CfgOutConnectInProgress,
  CfgOutHostUnreachable,
  CfgOutHostAlive,
  CfgOutMsgSending,
  CfgOutMsgNew
} CfgOutStatus_t;

typedef enum CfgOutRequest {
  CfgOutStatic = 0,
  CfgOutDynamic,
  CfgOutOnRequest
} CfgOutRequest_t;

#define CFGOUT_TCP_TMO    -1.
#define CFGOUT_INPROGRESS CFG_CONTINUE
#define CFGOUT_CSM_ADD_TYPE  "CFGOUT_CSM_ADD"
#define CFGOUT_CSM_RM_TYPE   "CFGOUT_CSM_RM"
#define CFGOUT_GRP_ADD_TYPE  "CFGOUT_GRP_ADD"
#define CFGOUT_GRP_RM_TYPE   "CFGOUT_GRP_RM"

typedef int (*CfgOutPrinter_t)(char* format, va_list args);
typedef int (*CfgOutBuildMsg_t)(CmMessage message, void *arg, char *consumer,
                                char *group);

extern void CfgOutCmEnd(void);
extern void CfgOutCmInit(void);
extern int CfgOutDomainGroupAdd(char *domain, char *group);
extern int CfgOutDomainGroupRemove(char *domain, char *group);
extern CfgOutPrinter_t CfgOutInstallPrinter(CfgOutPrinter_t printer);
extern int CfgOutGroupConsumerAdd(char *group, char *name, int retry,
                                  int priority, CfgOutRequest_t request,
                                  char *owner, char *host);
extern int CfgOutGroupConsumerDataAdd(char *group, char *name, Ulong data);
extern int CfgOutGroupConsumerPost(char *group, char *name,
                                   CfgOutBuildMsg_t buildMsg, void *arg);
extern int CfgOutGroupConsumerRemove(char *group, char *name);
extern int CfgOutGroupConsumerRequest(char *group, char *name,
                                      CfgOutBuildMsg_t buildMsg, void *arg,
                                      double timeout);
extern CfgOutStatus_t CfgOutGroupConsumerStatusGet(char *group, char *name);
extern int CfgOutGroupDebugSet(char *group, int debug);
extern char *CfgOutGroupDefaultGet(void);
extern void CfgOutGroupDefaultSet(char *group);
extern void CfgOutGroupFree(char *group);
extern CfgOutBuildMsg_t CfgOutGroupInstallBuilder(char *group,
                                                  CfgOutBuildMsg_t buildMsg,
                                                  void *arg);
extern int CfgOutGroupNbConsumerGet(char *group );
extern int CfgOutGroupNew(char *group, CfgParse_t *cfgParse, int maxConsumer,
                          int maxGroup, int threshold, int debug);
extern int CfgOutGroupNsPeriodSet(char *group, int period);
extern int CfgOutGroupPost(char *group, CfgOutBuildMsg_t buildMsg, void *arg);
extern int CfgOutGroupStatusGet(char *group, char *name,
                                CfgOutStatus_t *status);
extern void CfgOutGroupThresholdSet(char *group, int threshold);
extern CfgOutBuildMsg_t CfgOutGroupUninstallBuilder(char *group);
extern int CfgOutParserInit(CfgParse_t *cfgParse);

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CfgOut_h */
