/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

#include <CfgHeader.h>

#ifndef CfgParse_h
#define CfgParse_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define CFG_NO_ARG        -3
#define CFG_KEY_ATTRIBUTE 0xFACEBABE
#define CFG_KEY           0xBADEDEAD
#define CFG_NONE_KEY      0xFFFFFFFF
#define CFG_MAX_ATTR      128 
#define CFG_MAX_STACK     CFG_MAX_ATTR + 4
#define CFG_MAX_HENUM     256           
#define CFG_DSIZE         (sizeof(double)/sizeof(Ulong))
#define CFG_MAX_NAME      256
#define CFG_MAXPATHLEN    1024

#define CFG_VA_LIST_IDX(idx, narg) -(((idx) << 16) | ((narg) & 0xFFFF))
#define CFG_VA_LIST                CFG_VA_LIST_IDX(1, 1)

typedef enum CfgType{
  CfgNone,                                            /* Dummy entry not used */
  CfgFlag,                                         /* No attribute just a key */
  CfgConstString,                                  /* Static string attribute */
  CfgString,                                              /* String attribute */
  CfgBoolean,                                            /* Boolean attribute */
  CfgReal,                                                /* Double attribute */
  CfgHex,                                           /* Long integer attribute */
  CfgDec,                                                /* Integer attribute */
  CfgFunction,                                          /* Function attribute */
  CfgEnum,                                                  /* Enum attribute */
  CfgProcessing,                                      /* Processing attribute */
  CfgGetFunction			       /* No stack function attribute */
} CfgType_t;

typedef union CfgDouble{
  Ulong  i[2];
  double d;
} CfgDouble_t;

typedef struct CfgParse CfgParse_t;
typedef struct CfgDataType CfgDataType_t;
typedef int (*CfgParsePrinter_t) (const char* format, va_list args);
extern CfgParsePrinter_t CfgParseInstallPrinter( CfgParsePrinter_t printer );

extern int   CfgBufToFile(char *, char *);
extern char  *CfgDbGet(int, void *, void *(*)(), char *(*)());
extern int   CfgDbPut(char *, char *, void (*)());
extern char  *CfgFileToBuf(char *);
extern char  *CfgMapFile(char *);
extern int   CfgParseAdd(CfgParse_t *, char *, int, ...);
extern int   CfgParseArg(CfgParse_t *, int, char **);
extern int   CfgParseBuffer(CfgParse_t *, char *);
extern char  *CfgParseExtract(CfgParse_t *, char *, CfgBool_t);
extern int   CfgParseFile(CfgParse_t *, char *);
extern CfgParse_t *CfgParseFree(CfgParse_t *);
extern int   CfgParseFunctionAdd    (CfgParse_t *, char *, int (*)(), void *,
				     int, ...);
extern int   CfgParseGetFunctionAdd (CfgParse_t *, char *, 
				     int (*)(void *, CfgDataType_t *), 
				     void *,
				     int, ...);

extern double    CfgParseGetNextReal 	    (CfgDataType_t *dataType);
extern long int  CfgParseGetNextHex 	    (CfgDataType_t *dataType);
extern int   	 CfgParseGetNextDec 	    (CfgDataType_t *dataType);
extern char 	*CfgParseGetNextString 	    (CfgDataType_t *dataType);
char 		*CfgParseGetNextConstString (CfgDataType_t *dataType);
extern int   	 CfgParseGetNextEnum 	    (CfgDataType_t *dataType);

int 		 CfgParseGetResult 	    (CfgDataType_t *dataType);
  
extern CfgParse_t *CfgParseNew(void);
extern int   CfgParseSetEnumAttr(CfgParse_t *, char *, long);
extern char  *CfgPrintError(void);
extern int   CfgSetErrorMsg(char *, ...);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CfgParse_h */
