/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

//#include <time.h> 
#include <semaphore.h>
//#include <pthread.h>
//#include <stdarg.h>
#include <CfgHeader.h>
#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

#ifndef CfgQueue_h
#define CfgQueue_h

#define CFGQUEUE_CHECK -1.

typedef struct CfgRequest{
  void              *request;                           /* Pointer of request */
  struct CfgRequest *next;           /* Pointer to next request, NULL if none */
} CfgRequest_t;

typedef int (*CfgQueuePrinter_t)(char* format, va_list args);

typedef struct CfgQueue{
  char            *name;                                      /* Queue's name */
  pthread_mutex_t lock;                                      /* Queue's mutex */
  sem_t           sync;                                  /* Queue's semaphore */
  int             nbRequest;                    /* Number of request in queue */
  int             threshold;                            /* Threshold of queue */
  CfgRequest_t    *head;                    /* Head of linked-list of request */
  CfgRequest_t    *tail;                    /* Tail of linked-list of request */
}CfgQueue_t;

extern void              *CfgDequeue (CfgQueue_t *queue, double timeout);
extern int               CfgEnqueue (CfgQueue_t *queue, void *request);
extern int               CfgQueueFlush (CfgQueue_t *queue, int nbRequest);
extern CfgQueue_t        *CfgQueueFree (CfgQueue_t *queue);
extern int               CfgQueueGetValue (CfgQueue_t *queue);
extern CfgQueuePrinter_t CfgQueueInstallPrinter (CfgQueuePrinter_t printer);
extern CfgQueue_t        *CfgQueueNamedNew(int nelem, char *name);
extern CfgQueue_t        *CfgQueueNew (int nelem);

#endif /* CfgQueue_h */
