/* SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Cfg - A library for Virgo process implementation
 *
 * Copyright © 2001-2021 Laboratoire de physique des particules d'Annecy - CNRS
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *   Fatih Bellachia <fatih.bellachia@lapp.in2p3.fr>
 *   Laurent Fournier <laurent.fournier@lapp.in2p3.fr>
 *   Alain Masserot <alain.masserot@lapp.in2p3.fr>
 */

#include <CfgHeader.h>
#include <CfgLib.h>

#ifndef CfgVirgo_h
#define CfgVirgo_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define CFG_NOCM "none" 
/*-------------------------------------- private user interface message types */
#define CFG_CM_UI_RQ_ACTIVATION "UIRqActivation"
#define CFG_CM_UI_ACTIVATION    "UIActivation" /*----- Return a message with: */
/*-------------------------------------------- text:                 Hostname */
/*-------------------------------------------- text:               Activation */
/*-------------------------------------------- int :                      Pid */
/*-------------------------------------------- int :               Start time */
/*-------------------------------------------- text:                   CmName */
/*-------------------------------------------- text:                   ElName */
/*-------------------------------------------- text:                  Logfile */
/*-------------------------------------------- text:        Configuration tag */
/*-------------------------------------------- text:    Configuration content */

#define CFG_CM_UI_RQ_INFO       "UIRqInfo"
#define CFG_CM_UI_INFO          "UIInfo"      /*------ Return a message with: */
/*-------------------------------------------- int :             Current time */
/*-------------------------------------------- int : Current Supervisor state */
/*-------------------------------------------- text:     Current Server state */
/*-------------------------------------------- int :   Data segment size used */
/*----------------------------------------------------------------- Loop on : */
/*-------------------------------------------- int :              Error Level */
/*-------------------------------------------- text:                  Message */
/*-------------------------------------------- int :          Message counter */

#define CFG_CM_UI_RQ_LOG "UIRqLog"
#define CFG_CM_UI_LOG    "UILog"              /*------ Return a message with: */
/*-------------------------------------------- int :             Current time */
/*-------------------------------------------- int : Current Supervisor state */
/*-------------------------------------------- text:     Current Server state */
/*-------------------------------------------- int :   Data segment size used */
/*-------------------------------------------- int :  last config update time */
/*----------------------------------------------------------------- Loop on : */
/*-------------------------------------------- int :              Error Level */
/*-------------------------------------------- text:                  Message */
/*-------------------------------------------- int :          Message counter */
/*-------------------------------------------- int:        Message time stamp */

/*-------------------------------------------------- Frame Builder Cm Message */
#define CFG_CM_FB_GET_CONFIG     "FbGetConfig"
#define CFG_CM_FB_CONFIG_DATA    "FbConfigData" /*---- Return a message with: */
/*-------------------------------------------- text:    Current configuration */


/*----------------------------------------------------------------------------*/
#define CFG_CM_EXIT    "CfgExit"       /*------------ Cm Message Type to Exit */
#define CFG_CM_KILL    "CfgKill"       /*------------ Cm Message Type to Kill */
#define CFG_CM_RESTART "CfgReStart"    /*--------- Cm Message Type to ReStart */
#define CFG_CM_RFLAG   "CfgRFlag"      /* Cm Message Type to set report Flags */
#define CFG_CM_SVCFG   "CfgSaveConfig" /*- CmMessage to save the using config */

/*----------------------------------------------------------------------------*/
extern int  CfgConfAdd( char *format, ... );
extern int  CfgConfigCommit( char *confTag );
extern char *CfgConfigLoad( char *confTag );
extern void CfgClose( void );
extern int  CfgFinished( void );
extern CfgBool_t CfgFromFile( char *confTag );
extern char *CfgGetCmName( void );
extern char *CfgGetConfig( void );
extern int  CfgGetDebug( void );
extern FILE *CfgGetLogStream( void );
extern FILE *CfgGetLogStreamFlush( double tmo );
extern CfgServerState_t CfgGetRequestedState( void );
extern CfgServerState_t CfgGetState( void );
extern int  CfgIdle( int argc, char *argv[], int msgNb );
extern int  CfgIdleWithUserActivationFnt( int argc, char *argv[], int msgNb,
					  CfgUserActivationGetFnt_t f, void *param);
extern int  CfgLogFPrint( char *fmt, ... )
  __attribute__ ((format( printf, 1, 2)));

extern int  CfgMsgAddFmtv(int errLvl, int debug, char *tag, char *fmt,
			  va_list args  );

extern int  CfgMsgAddFmt(int errLvl, int debug, char *fmt, ... )
  __attribute__ ((format(printf, 3, 4)));

extern int  CfgMsgAddFmtTag(int errLvl, int debug, char *tag, char *fmt, ... );

extern int  CfgMsgAddInfo(char *fmt, ... )
  __attribute__ ((format(printf, 1, 2)));

extern int  CfgMsgAddError(char *fmt, ... )
  __attribute__ ((format(printf, 1, 2)));

extern int  CfgMsgAddFatal(char *fmt, ... )
  __attribute__ ((format(printf, 1, 2)));

extern int  CfgMsgAddUserInfo(char *fmt, ... )
  __attribute__ ((format(printf, 1, 2)));

extern int  CfgMsgAddWarning(char *fmt, ... )
  __attribute__ ((format(printf, 1, 2)));
extern int  CfgMsgSendWithTimeout( double tmo );

extern int  CfgMsgPrintInfo(char *fmt, ... )
  __attribute__ ((format(printf, 1, 2)));

extern int  CfgMsgPrintError(char *fmt, ... )
  __attribute__ ((format(printf, 1, 2)));

extern int  CfgMsgPrintWarning(char *fmt, ... )
  __attribute__ ((format(printf, 1, 2)));

#define  CfgMsgPrintFatal CfgMsgAddFatal
extern int  CfgMsgPrinter( char *format, va_list args );
extern int  CfgParseIdleAdd( CfgParse_t *p );
extern int  CfgParseIdleAddNoAction( CfgParse_t *p );
extern int  CfgReachState( CfgServerState_t state );
extern char *CfgRunTimeStr( char *runTime, size_t len);
extern CfgConfigFnt_t CfgSetConfigFnt( CfgConfigFnt_t configFnt );
extern int CfgSetDebug( int debug );
extern int CfgSetStateFnt( int cState, int rState,
			   CfgStateReachFnt_t f, void *q );
extern int CfgSetRFlag( int log, int stdOut, int cmTrace );
extern int CfgSetRPeriodTime( double period );
extern int CfgSetUserActivationFnt( CfgUserActivationGetFnt_t getActivation,
				    void  *param );
extern void CfgTerminate(void);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CfgVirgo_h */

