#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <libgen.h>
#include <CbfClean.h>

#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

#ifdef __Lynx__
extern char *optarg;
extern int optind;
extern int getopt(int, char *[], char *);
#endif /* __Lynx__ */

#ifdef __osf__
#define sys_siglist __sys_siglist
#endif /* __osf__ */

/*----------------------------------------------------------------------------*/
/*- quit ---------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
void quit(int sig){
  printf("\n\nreceive signal `%s'.\n", strsignal(sig));

  exit(sig);
}

/*----------------------------------------------------------------------------*/
/*- tchao --------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
static void *tchao(void *arg) {

  printf("\ntchao...\n");

  return((void *)CbfCleanDone("tchao", arg));
}

/*----------------------------------------------------------------------------*/
/*- main ---------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int main(int argc, char *argv[]){
int c, signo;

#ifdef USE_MW
  mwStatistics(2);
#endif

  while((c = getopt(argc, argv, "hs:")) != -1){
    switch(c){
      case 's':
        if(sscanf(optarg, "%d", &signo) > 0){ signal(signo, quit); }
        break;
      default:
        fprintf(stderr, "usage: %s [-h] [-s <signal>]\n", basename(argv[0]));
        fprintf(stderr,"        -h      Print out this message\n");
        fprintf(stderr,"        -s      <signal> number\n");

        exit(-1);
    }
  }

  CbfCleanSetDebug(-2, (char *)NULL);

  CbfCleanAdd((CbfClean_t *)NULL, "tchao", tchao, NULL);

  printf("\n\t\t>>> Press on \033[7m<CTRL-C>\033[m to exit <<<");
  fflush(stdout);

  sigpause(0);

  exit(EXIT_SUCCESS);
}
