#include <stdio.h>
#include <stdlib.h>
#include <CbfClean.h>
#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

static void *TtFree( void *arg );
static int TtNew( CbfClean_t *clean, char *fName, void *(*function)(),
		  void *arg );
static void TtExit(void);

/*----------------------------------------------------------------------------*/
static void *TtCleanFree( void *arg ) {
  char lfName[50];
  sprintf( lfName, "TtCleanFree%02d", (int)arg);
  return((void*)CbfCleanDone( lfName, arg));
}

/*----------------------------------------------------------------------------*/
static void TtExit(void) {
  printf("TtExit call\n");
  return;
}


/*----------------------------------------------------------------------------*/
static void *TtFree( void *arg ) {
  char lfName[50];
  sprintf( lfName, "TtFree%02d", (int)arg);
  return((void*)CbfCleanDone( lfName, arg));
}

/*----------------------------------------------------------------------------*/
static void *TtFreeMgr( void *arg ) {
  CbfClean_t *clean;
  clean = (CbfClean_t *)arg;
  clean = CbfCleanFree(clean);
  return((void*)CbfCleanDone( "TtFreeMgr", arg));
}

/*----------------------------------------------------------------------------*/
static int TtNew( CbfClean_t *clean, char *fName, void *(*function)(),
		  void *arg ){
  char lfName[50];
  sprintf( lfName, "%s%02d", fName, (int)arg);
  if( !CbfCleanAdd( clean, lfName, function, arg) ) return(CBF_FAIL);
  else return(CBF_OK);
}

/*----------------------------------------------------------------------------*/
int CbfCleanB1 ( int nb ) {
  int i, rtn = CBF_OK;
  char lfName[50];
  CbfClean_t *clean;

  printf("CbfCleanB1 > Begin\n");
  clean = CbfCleanNew("CbfCleanB1"); /*------------------ Create a CbfClean_t */
  /*---------------------------------------------- Add function to CbfCleanTt */
  for( i = 0; i < nb; i++ ) {
   rtn |= TtNew( clean, "TtCleanFree", TtCleanFree, (void*)i ); 
  }
	    
  /*---------------------------------------------------- Performs some TtFree */
  TtCleanFree( (void*)0 );
  TtCleanFree( (void*)(nb-5) );
  TtCleanFree( (void*)(nb-1) );
  /*------------------------------------------------------ Performs upto ...  */
  sprintf( lfName, "TtCleanFree%02d", nb-2 ); 
  CbfCleanFreeTag( lfName, (void*)(nb-2) );
  sprintf( lfName, "TtCleanFree%02d", nb-4 ); 
  CbfCleanFreeTag( lfName, (void*)(nb-4) );
  sprintf( lfName, "TtCleanFree%02d", 2 ); 
  CbfCleanFreeTag( lfName ,(void*)2 );
  /*----------------------------------------------- Performs the full cleanup */
  if( !(clean = CbfCleanFree(clean)) ) rtn = CBF_FAIL;
  /*----------------------------------------------- Performs the full cleanup */
  CbfCleanFree( CbfCleanNew(NULL) );
  return(rtn);
}

/*----------------------------------------------------------------------------*/
int CbfCleanB2 ( int nb ) {
  int i, rtn = CBF_OK;
  CbfClean_t *clean;
  
  printf("CbfCleanB2 > Begin\n");
  /*-------------------------------------------- Add function to CbfCleanRoot */
  for( i = 0; i < nb; i++ ) {
   rtn |= TtNew( (CbfClean_t*)NULL, "TtFree", TtFree, (void*)i ); 
  }
  /*---------------------------------------------- Add function to CbfCleanTt */
  clean = CbfCleanNew("CbfCleanB2"); /*------------------ Create a CbfClean_t */
  /*--------------------------------------------- Add function to CbfCleanTt1 */
  for( i = nb; i < 2*nb; i++ ) {
   rtn |= TtNew( clean, "TtCleanFree", TtCleanFree, (void*)i ); 
  }
  /*---------------------------------------------------- Performs some TtFree */
  TtCleanFree( (void*)(2*nb-2) );
  TtCleanFree( (void*)(nb+1) );
  /*-------------------------------------- Performs the cleanup upto TtFree00 */
  CbfCleanFreeTag( "TtFree00", (void*)0 );
  /*----------------------------------------------- Performs the full cleanup */
  CbfCleanFree( CbfCleanNew(NULL) );
  return(rtn);
}

/*----------------------------------------------------------------------------*/
int CbfCleanB3 ( int nb ) {
  int i, rtn = CBF_OK;
  CbfClean_t *clean;

  printf("CbfCleanB3 > Begin\n");
  /*-------------------------------------------- Add function to CbfCleanRoot */
  for( i = 0; i < nb; i++ ) {
   rtn |= TtNew( (CbfClean_t*)NULL, "TtFree", TtFree, (void*)i ); 
  }
  /*---------------------------------------------- Add function to CbfCleanTt */
  clean = CbfCleanNew("CbfCleanB3_1"); /*---------------- Create a CbfClean_t */
  /*-------------------------------------------- Add function to CbfCleanB3_1 */
  for( i = nb; i < 2*nb; i++ ) {
   rtn |= TtNew( clean, "TtCleanFree", TtCleanFree, (void*)i ); 
  }
  /*-------------------------------------------- Add function to CbfCleanRoot */
  for( i = 2*nb; i < 3*nb; i++ ) {
   rtn |= TtNew( (CbfClean_t*)NULL, "TtFree", TtFree, (void*)i ); 
  }
  /*---------------------------------------------- Add function to CbfCleanTt */
  CbfCleanNew("CbfCleanB3_2"); /*--------------- Create a CbfClean_t */
  /*-------------------------------------------- Add function to CbfCleanRoot */
  for( i = 3*nb; i < 4*nb; i++ ) {
   rtn |= TtNew( (CbfClean_t*)NULL, "TtFree", TtFree, (void*)i ); 
  }
  /*------------------------------------------------------ Performs some Free */
  TtFree( (void*)1 );
  TtCleanFree( (void*)(nb+2) );
  TtFree( (void*)(3*nb+2) );
  /*-------------------------------------- Performs the cleanup upto TtFree00 */
  CbfCleanFreeTag( "TtFree02", (void*)2);

  CbfCleanFree(CbfCleanNew(NULL));
  return(rtn);
}

/*----------------------------------------------------------------------------*/
int CbfCleanB4 ( int nb ) {
  CbfClean_t *clean;
  int i, rtn = CBF_OK;

  printf("CbfCleanB4 > Begin\n");
  /*-------------------------------------------- Add function to CbfCleanRoot */
  for( i = 0; i < nb; i++ ) {
   rtn |= TtNew( (CbfClean_t*)NULL, "TtFree", TtFree, (void*)i ); 
  }
  /*---------------------------------------------- Add function to CbfCleanTt */
  clean = CbfCleanNew("CbfCleanB4"); /*------------------ Create a CbfClean_t */
  /*---------------------------------------------- Add function to CbfCleanB4 */
  for( i = 0; i < nb; i++ ) {
   rtn |= TtNew( clean, "TtCleanFree", TtCleanFree, (void*)i ); 
  }
  /*-------------------------------------------- Add function to CbfCleanRoot */
  for( i = nb; i < 2*nb; i++ ) {
   rtn |= TtNew( (CbfClean_t*)NULL, "TtFree", TtFree, (void*)i ); 
  }
  /*----------------------------------------------------------- Release clean */
  clean = CbfCleanFree(clean);
  CbfCleanFree(CbfCleanNew(NULL));
  return(rtn);
}

/*----------------------------------------------------------------------------*/
int CbfCleanB5 ( int nb ) {
  CbfClean_t *clean;
  int i, rtn = CBF_OK;

  printf("CbfCleanB5 > Begin\n");
  /*-------------------------------------------- Add function to CbfCleanRoot */
  for( i = 0; i < nb; i++ ) {
   rtn |= TtNew( (CbfClean_t*)NULL, "TtFree", TtFree, (void*)i ); 
  }
  /*---------------------------------------------- Add function to CbfCleanTt */
  clean = CbfCleanNew("CbfCleanB5"); /*------------------ Create a CbfClean_t */
  CbfCleanAdd( (CbfClean_t*)NULL, "TtFreeMgr", TtFreeMgr, clean );
  /*---------------------------------------------- Add function to CbfCleanB4 */
  for( i = 0; i < nb; i++ ) {
   rtn |= TtNew( clean, "TtCleanFree", TtCleanFree, (void*)i ); 
  }
  /*-------------------------------------------- Add function to CbfCleanRoot */
  for( i = nb; i < 2*nb; i++ ) {
   rtn |= TtNew( (CbfClean_t*)NULL, "TtFree", TtFree, (void*)i ); 
  }
  return(rtn);
}

/*----------------------------------------------------------------------------*/
int 
main (int argc, char **argv)
{
#ifdef USE_MW
  mwStatistics(2);
#endif

  CbfCleanSetExitFnt( TtExit );
  /*CbfCleanB1(13); ------------------------------------------------- Basic 1 */
  /*CbfCleanB2(7);  ------------------------------------------------- Basic 2 */
  /*CbfCleanB3(5);  ------------------------------------------------- Basic 3 */
  CbfCleanB4(3);  /*------------------------------------------------- Basic 4 */
  CbfCleanB5(5);  /*------------------------------------------------- Basic 5 */

  printf("Before Exit \n");
  exit(EXIT_SUCCESS);
}
