#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <CbfHash.h>


int main(int argc, char *argv[]){
  CbfH_t *hTab;
  CbfHEntry_t *entry;

  hTab = CbfHNew( -1024 );

  entry = CbfHFind( hTab, "Test");
  if( entry == NULL ) printf(" Element not found\n" );

  entry = CbfHEnter( hTab, "VxBtFree_2035ad30", (char*)0x2035ac20 );
  CbfHPrint(hTab);
  printf("\n");

  entry = CbfHEnter( NULL, "Test", (char*)1 );
  CbfHPrint(hTab);
  printf("\n");

  entry = CbfHEnter( NULL, "Test", (char*)2  );
  CbfHPrint(hTab);
  printf("\n");

  entry = CbfHFind( NULL, "Test");
  CbfHEntryRemove( entry );
  CbfHPrint(hTab);
  printf("\n");

  entry = CbfHEnter( hTab,  "Test", (char*)3 );
  entry = CbfHEnter( hTab,  "Test1", (char*)4 );
  entry = CbfHEnter( hTab,  "Test", (char*)5 );
  _CbfHPrint(NULL, "Vx");
  CbfHPrint(NULL);
  printf("\n");

  entry = CbfHFind( hTab, "Test1" );
  if( entry != NULL ) printf(" Element found\n" );
  hTab = CbfHFree(hTab);
  printf("hTab should be no null: %p\n", hTab);

  /*New Test */
  printf("\n");
  hTab = CbfHNew( 13 );

  entry = CbfHFind( hTab, "Test");
  if( entry == NULL ) printf(" Element not found\n" );

  entry = CbfHEnter( hTab, "VxBtFree_2035ad30", (char*)0x2035ac20 );
  CbfHPrint(hTab);

  entry = CbfHEnter( hTab, "Test", (char*)1 );
  CbfHPrint(hTab);

  entry = CbfHEnter( hTab, "Test", (char*)2  );
  CbfHPrint(hTab);

  entry = CbfHFind( hTab, "Test");
  CbfHEntryRemove( entry );
  CbfHPrint(hTab);

  entry = CbfHEnter( hTab,  "Test", (char*)3 );
  entry = CbfHEnter( hTab,  "Test1", (char*)4 );
  entry = CbfHEnter( hTab,  "Test", (char*)5 );
  _CbfHPrint(hTab, "Vx");
  CbfHPrint(hTab);
  entry = CbfHFind( hTab, "Test1" );
  if( entry != NULL ) printf(" Element found\n" );
  hTab = CbfHFree(hTab);
  printf("hTab should be null: %p\n", hTab);

  printf("\nRoot HTable\n");
  CbfHPrint(NULL);
  exit(0);
}

