
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <CfgLib.h>
#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

typedef enum Color{
  none=0,
  red,
  blue,
  green,
  white,
  black,
  grey,
  orange,
  yellow,
  maroon,
  purple
}Color_t;

char *tabColor[]={
  "unknown",
  "red",
  "blue",
  "green",
  "white",
  "black",
  "grey",
  "orange",
  "yellow",
  "maroon",
  "purple"
};

void france(void){
  printf("country is FRANCE and flag color is: [Blue][White][Red]\n");
}

void italia(void){
  printf("country is ITALIA and flag color is: [Green][White][Red]\n");
}

int main(int argc, char *argv[]){
CfgParse_t   *cfgParse;
Color_t      color;
void (*function)(void) = (void (*)(void))NULL;
char         filename[1024];

  if((cfgParse = CfgParseNew()) == (CfgParse_t *)NULL){ exit(-1); }

  printf("[ COLOR ] [VALUE]\n");
  for(color=red; color<=purple; color++){
    CfgParseSetEnumAttr(cfgParse, tabColor[color], color);
    printf(" %-7s   %d\n", tabColor[color], color);
  }
  printf("\n");

  CfgParseSetEnumAttr(cfgParse, "France", (long)france);
  CfgParseSetEnumAttr(cfgParse, "Italia", (long)italia);

  CfgParseAdd(cfgParse, "PREFERENCE", 1, CfgEnum, &color);
  CfgParseAdd(cfgParse, "COUNTRY",    1, CfgEnum, &function);

  strcpy(filename, XSTR(CFG_PATH) );
  strcat(filename, "/cfg/Enum.cfg");

  if(CfgParseFile(cfgParse, filename) == CFG_FAIL){
    CfgParseFree(cfgParse);
    exit(-1);
  }

  CfgParseFree(cfgParse);

  printf("your selected color is %s (%d)\n", tabColor[color], color);

  if(function){ (*function)(); }

  exit(0);
}
