
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <CfgLib.h>
#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

int foo_no_stack (void *arg, CfgDataType_t *dataType)
{
  ulong address;
  int i;
  char *name;
  int nb;

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  nb = CfgParseGetNextDec (dataType);
  printf("# arg: %d\n", nb);

  for(i=0; i < nb; i++){
    name = CfgParseGetNextString (dataType);
    address = CfgParseGetNextHex (dataType);
    printf("ADC (%s) @: 0x%08lx\n",
	   name?name:"nil", address);
  }

  return CfgParseGetResult (dataType);
}

int foo(void *arg, int nb, ...){
va_list ap;
register ulong address;
register int i;
char     *name;

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  va_start(ap, nb);

  printf("# arg: %d\n", nb);

  for(i=0; i<nb; i++){
     name    = va_arg(ap, char *);
     address = va_arg(ap, ulong);
     printf("ADC (%s) @: 0x%08lx\n",
            name?name:"nil", address);
  }

  va_end(ap);

  return(CFG_OK);
}

int main(int argc, char *argv[]){
register int rtn;
CfgParse_t   *cfgParse;
char         filename[1024];

  if((cfgParse = CfgParseNew()) == (CfgParse_t *)NULL){ exit(-1); }

  rtn = CfgParseGetFunctionAdd(cfgParse, "ADC", 
			       (int (*)())foo_no_stack, 
			       (void *)NULL,
			       17,        CfgDec,
			       CfgString, CfgHex,
			       CfgString, CfgHex,
			       CfgString, CfgHex,
			       CfgString, CfgHex,
			       CfgString, CfgHex,
			       CfgString, CfgHex,
			       CfgString, CfgHex,
			       CfgString, CfgHex);
#if 0
  rtn = CfgParseFunctionAdd(cfgParse, "ADC", 
			    (int (*)())foo, 
			    (void *)NULL,
			    17,        CfgDec,
			    CfgString, CfgHex,
			    CfgString, CfgHex,
			    CfgString, CfgHex,
			    CfgString, CfgHex,
			    CfgString, CfgHex,
			    CfgString, CfgHex,
			    CfgString, CfgHex,
			    CfgString, CfgHex);
#endif

  if(rtn == CFG_FAIL){
    CfgParseFree(cfgParse);
    exit(-1);
  }

  strcpy(filename, XSTR(CFG_PATH) );
  strcat(filename, "/cfg/Foo.cfg");
 
  if(CfgParseFile(cfgParse, filename) == CFG_FAIL){
    CfgParseFree(cfgParse);
    exit(-1);
  }

  CfgParseFree(cfgParse);

  exit(0);
}
