
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <CfgLib.h>
#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

/*----------------------------------------------------------------------------*/
/*- bar ----------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int bar(void *arg, CfgDouble_t d1, char *name, CfgDouble_t d2, ulong address,
        int val){

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  printf("ARG    : %ld\n", (long)arg);
  printf("D1     : %g\n", d1.d);
  printf("NAME   : %s\n", name?name:"nil");
  printf("D2     : %g\n", d2.d);
  printf("ADDRESS: 0x%08lx\n", address);
  printf("VAL    : %d\n", val);

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- channel ------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int channel(void *arg, int channel, char *name, int pdid, char *type,
            CfgDouble_t ped, CfgDouble_t gain, CfgDouble_t a1,
            CfgDouble_t a2, CfgDouble_t b1, CfgDouble_t b2,
            CfgDouble_t phase){

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  printf("channel: %d\n", channel);
  printf("name   : %s\n", name?name:"nil");
  printf("pdid   : %d\n", pdid);
  printf("type   : %s\n", type?type:"nil");
  printf("ped    : %g\n", ped.d);
  printf("gain   : %g\n", gain.d);
  printf("a1     : %g\n", a1.d);
  printf("a2     : %g\n", a2.d);
  printf("b1     : %g\n", b1.d);
  printf("b2     : %g\n", b2.d);
  printf("phase  : %g\n", phase.d);

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- daqChannel ---------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int daqChannel(void *arg, int idCh, char *name, CfgDouble_t bias){

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  printf("channel: %d\n", idCh);
  printf("name   : %s\n", name? name: "nil");
  printf("bias   : %g\n", bias.d);

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- foo_2nd ------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int foo_2nd(void *arg, int mrd, CfgDouble_t ff, CfgDouble_t sf, int ns,
            ulong gps1, ulong gps2, CfgDouble_t rtte, ulong ti, char *name){

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  printf("MRD : %d\n", mrd);
  printf("FF  : %g\n", ff.d);
  printf("SF  : %g\n", sf.d);
  printf("NS  : %d\n", ns);
  printf("GPS1: 0x%08lx\n", gps1);
  printf("GPS2: 0x%08lx\n", gps2);
  printf("RTTE: %g\n", rtte.d);
  printf("TI0 : 0x%08lx\n", ti);
  printf("NAME: %s\n", name?name:"nil");

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- foo ----------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int foo(void *arg, int mrd, CfgDouble_t ff, CfgDouble_t sf, int ns, ulong gps1,
        ulong gps2, CfgDouble_t rtte, ulong ti, char *name){
register int rtn = CFG_OK;
CfgParse_t   *cfgParse;
char         *buffer, filename[1024];

  if((cfgParse = CfgParseNew()) == (CfgParse_t *)NULL){ return(CFG_FAIL); }

  rtn |= CfgParseFunctionAdd(cfgParse, "FOO_2ND", foo_2nd, (void *)NULL, 9,
                                                          CfgDec,
                                                          CfgReal,
                                                          CfgReal,
                                                          CfgDec,
                                                          CfgHex,
                                                          CfgHex,
                                                          CfgReal,
                                                          CfgHex,
                                                          CfgString);

  if(rtn == CFG_FAIL){
    CfgParseFree(cfgParse);
    return(CFG_FAIL);
  }

  strcpy(filename, "../cfg/Func.cfg");

  if((buffer = CfgFileToBuf(filename)) == (char *)NULL){
    CfgParseFree(cfgParse);
    return(CFG_FAIL);
  }

  if(CfgParseBuffer(cfgParse, buffer) == CFG_FAIL){
    CfgPrintError();
    CfgParseFree(cfgParse);
    return(CFG_FAIL);
  }

  free(buffer);

  CfgParseFree(cfgParse);

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  printf("MRD : %d\n", mrd);
  printf("FF  : %g\n", ff.d);
  printf("SF  : %g\n", sf.d);
  printf("NS  : %d\n", ns);
  printf("GPS1: 0x%08lx\n", gps1);
  printf("GPS2: 0x%08lx\n", gps2);
  printf("RTTE: %g\n", rtte.d);
  printf("TI0 : 0x%08lx\n", ti);
  printf("NAME: %s\n", name?name:"nil");

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- func ---------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int func(void *arg, ulong address){
  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  printf("ADDRESS: 0x%08lx\n", address);

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- ti -----------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int ti(void *arg, ulong address, char *mode, CfgDouble_t sf, char *type,
       CfgDouble_t freq, char *ws){

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  printf("ADDRESS  : 0x%08lx\n", address);
  printf("MODE     : %s\n", mode?mode:"nil");
  printf("SAMP FREQ: %g\n", sf.d);
  printf("TYPE     : %s\n", type?type:"nil");
  printf("FREQ     : %g\n", freq.d);
  printf("WARMSTART: %s\n", ws?ws:"nil");

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- vaListDec ----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int vaListDec(void *arg, int nb, ...){
va_list ap;
register int i;

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  va_start(ap, nb);
  for(i=0; i<nb; i++){
    int val;

    val = va_arg(ap, int);
    printf("[%2d/%2d] value: %d\n", i, nb, val);
  }
  va_end(ap);

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- vaListStr ----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int vaListStr(void *arg, int nb, ...){
va_list ap;
register int i;

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  va_start(ap, nb);
  for(i=0; i<nb; i++){
    char *string;

    string = va_arg(ap, char *);
    printf("[%2d/%2d] string: `%s'\n", i, nb, string);
  }
  va_end(ap);

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- vaListIdx ----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int vaListIdx(void *arg, CfgDouble_t f, int nb, ...){
va_list ap;
register int i;

  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  printf("f = %g\n", f.d);

  va_start(ap, nb);
  for(i=0; i<nb; i++){
    if(i % 2){
      char *string;

      string = va_arg(ap, char *);
      printf("[%2d/%2d] string: `%s'\n", i, nb, string);
    }
    else{
      int  val;

      val = va_arg(ap, int);
      printf("[%2d/%2d] value: %d\n", i, nb, val);
    }
  }
  va_end(ap);

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- main ---------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int main(int argc, char *argv[]){
register int rtn = CFG_OK;
CfgParse_t   *cfgParse;
char         *buffer, *exBuffer, filename[1024];

  if((cfgParse = CfgParseNew()) == (CfgParse_t *)NULL){ exit(-1); }

  rtn |= CfgParseFunctionAdd(cfgParse, "TIMING", ti, (void *)NULL, 6,
                                                            CfgHex,
                                                            CfgString,
                                                            CfgReal,
                                                            CfgString,
                                                            CfgReal,
                                                            CfgString);

  rtn |= CfgParseFunctionAdd(cfgParse, "FOO", foo, (void *)NULL, 9,
                                                          CfgDec,
                                                          CfgReal,
                                                          CfgReal,
                                                          CfgDec,
                                                          CfgHex,
                                                          CfgHex,
                                                          CfgReal,
                                                          CfgHex,
                                                          CfgString);

  rtn |= CfgParseFunctionAdd(cfgParse, "BAR", bar, (void *)1, 5,
                                                       CfgReal,
                                                       CfgString,
                                                       CfgReal,
                                                       CfgHex,
                                                       CfgDec);

  rtn |= CfgParseFunctionAdd(cfgParse, "BAR", bar, (void *)2, 5,
                                                       CfgReal,
                                                       CfgString,
                                                       CfgReal,
                                                       CfgHex,
                                                       CfgDec);

  rtn |= CfgParseFunctionAdd(cfgParse, "BAR", bar, (void *)3, 5,
                                                       CfgReal,
                                                       CfgString,
                                                       CfgReal,
                                                       CfgHex,
                                                       CfgDec);

  rtn |= CfgParseFunctionAdd(cfgParse, "FUNC", func, (void *)NULL, 1, CfgHex);


  rtn |= CfgParseFunctionAdd(cfgParse, "VA_LIST_IDX", (int (*)())vaListIdx,
                             (void *)NULL, CFG_VA_LIST_IDX(2, 2),
                             CfgReal, CfgDec, CfgString);

  rtn |= CfgParseFunctionAdd(cfgParse, "CHANNEL", (int (*)())channel,
                             (void *)NULL, 11, CfgDec, CfgString, CfgDec,
                             CfgString, CfgReal, CfgReal, CfgReal, CfgReal,
                             CfgReal, CfgReal, CfgReal);

  rtn |= CfgParseFunctionAdd(cfgParse, "DAQ_CHANNEL", (int (*)())daqChannel,
                             (void *)NULL, 3, CfgDec, CfgString, CfgReal);

  rtn |= CfgParseFunctionAdd(cfgParse, "VA_LIST_DEC", (int (*)())vaListDec,
                             (void *)NULL, CFG_VA_LIST, CfgDec);

  rtn |= CfgParseFunctionAdd(cfgParse, "VA_LIST_STR", (int (*)())vaListStr,
                             (void *)NULL, CFG_VA_LIST, CfgString);

  if(rtn == CFG_FAIL){
    CfgParseFree(cfgParse);
    exit(-1);
  }

  strcpy(filename, "../cfg/Func.cfg");

  if((buffer = CfgFileToBuf(filename)) == (char *)NULL){
    CfgParseFree(cfgParse);
    exit(-1);
  }

  if((exBuffer = CfgParseExtract(cfgParse, buffer, CfgFalse)) != (char *)NULL){
    printf("Extract data >>>\n%s <<<\n", exBuffer);
  }

  if(CfgParseBuffer(cfgParse, buffer) == CFG_FAIL){
    CfgPrintError();
    CfgParseFree(cfgParse);
    exit(-1);
  }

  free(buffer); 
  free(exBuffer);

  CfgParseFree(cfgParse);

  exit(0);
}
