
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <CfgLib.h>
#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

/*----------------------------------------------------------------------------*/
/*- bar ----------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#if 0
int bar(void *arg, CfgDouble_t d1, char *name, CfgDouble_t d2, ulong address,
	int val){
#endif
int bar (void *arg, CfgDataType_t *dataType)
{
  char *name;

  printf("\n>>>>> bar <<<<<\n");

  printf("ARG    : %ld\n", (long)arg);
  printf("D1     : %g\n", CfgParseGetNextReal (dataType));
  name = CfgParseGetNextString (dataType);
  printf("NAME   : %s\n", name?name:"nil");
  printf("D2     : %g\n", CfgParseGetNextReal (dataType));
  printf("ADDRESS: 0x%08lx\n", CfgParseGetNextHex (dataType));
  printf("VAL    : %d\n", CfgParseGetNextDec (dataType));

  return CfgParseGetResult (dataType);
}

/*----------------------------------------------------------------------------*/
/*- channel ------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#if 0
int channel(void *arg, int channel, char *name, int pdid, char *type,
            CfgDouble_t ped, CfgDouble_t gain, CfgDouble_t a1,
            CfgDouble_t a2, CfgDouble_t b1, CfgDouble_t b2,
            CfgDouble_t phase){
#endif
int channel(void *arg, CfgDataType_t *dataType)
{
  char *name;

  printf("\n>>>>> channel <<<<<\n");

  printf("channel: %d\n", CfgParseGetNextDec (dataType));
  name = CfgParseGetNextString (dataType);
  printf("name   : %s\n", name?name:"nil");
  printf("pdid   : %d\n", CfgParseGetNextDec (dataType));
  name = CfgParseGetNextString (dataType);
  printf("type   : %s\n", name?name:"nil");
  printf("ped    : %g\n", CfgParseGetNextReal (dataType));
  printf("gain   : %g\n", CfgParseGetNextReal (dataType));
  printf("a1     : %g\n", CfgParseGetNextReal (dataType));
  printf("a2     : %g\n", CfgParseGetNextReal (dataType));
  printf("b1     : %g\n", CfgParseGetNextReal (dataType));
  printf("b2     : %g\n", CfgParseGetNextReal (dataType));
  printf("phase  : %g\n", CfgParseGetNextReal (dataType));

  return CfgParseGetResult (dataType);
}

/*----------------------------------------------------------------------------*/
/*- daqChannel ---------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#if 0
int daqChannel(void *arg, int idCh, char *name, CfgDouble_t bias){
#endif
int daqChannel (void *arg, CfgDataType_t *dataType)
{
  char *name;
  
  printf("\n>>>>> daqChannel <<<<<\n");

  printf("channel: %d\n", CfgParseGetNextDec (dataType));
  name = CfgParseGetNextString (dataType);
  printf("name   : %s\n", name? name: "nil");
  printf("bias   : %g\n", CfgParseGetNextReal (dataType));

  return CfgParseGetResult (dataType);
}

/*----------------------------------------------------------------------------*/
/*- foo_2nd ------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#if 0
int foo_2nd(void *arg, int mrd, CfgDouble_t ff, CfgDouble_t sf, int ns,
            ulong gps1, ulong gps2, CfgDouble_t rtte, ulong ti, char *name){
#endif
int foo_2nd (void *arg, CfgDataType_t *dataType)
{
  char *name;

  printf("\n>>>>> foo_2nd <<<<<\n");

  printf("MRD : %d\n", CfgParseGetNextDec (dataType));
    printf("FF  : %g\n", CfgParseGetNextReal (dataType));
  printf("SF  : %g\n", CfgParseGetNextReal (dataType));
  printf("NS  : %d\n", CfgParseGetNextDec (dataType));
  printf("GPS1: 0x%08lx\n", CfgParseGetNextHex (dataType));
  printf("GPS2: 0x%08lx\n", CfgParseGetNextHex (dataType));
  printf("RTTE: %g\n", CfgParseGetNextReal (dataType));
  printf("TI0 : 0x%08lx\n", CfgParseGetNextHex (dataType));
  name = CfgParseGetNextString (dataType);
  printf("NAME: %s\n", name?name:"nil");

  return CfgParseGetResult (dataType);
}

/*----------------------------------------------------------------------------*/
/*- foo ----------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#if 0
int foo(void *arg, int mrd, CfgDouble_t ff, CfgDouble_t sf, int ns, ulong gps1,
        ulong gps2, CfgDouble_t rtte, ulong ti, char *name){
#endif
  
int foo(void *arg, CfgDataType_t *dataType)
{
  register int rtn = CFG_OK;
  CfgParse_t   *cfgParse;
  char         *buffer, filename[1024], *name;

  if((cfgParse = CfgParseNew()) == (CfgParse_t *)NULL){ return(CFG_FAIL); }

  rtn |= CfgParseGetFunctionAdd(cfgParse, "FOO_2ND", foo_2nd, 
				    (void *)NULL, 9,
				    CfgDec,
				    CfgReal,
				    CfgReal,
				    CfgDec,
				    CfgHex,
				    CfgHex,
				    CfgReal,
				    CfgHex,
				    CfgString);

  if(rtn == CFG_FAIL){
    CfgParseFree(cfgParse);
    return(CFG_FAIL);
  }

  strcpy(filename, "../cfg/Func.cfg");

  if((buffer = CfgFileToBuf(filename)) == (char *)NULL){
    CfgParseFree(cfgParse);
    return(CFG_FAIL);
  }

  if(CfgParseBuffer(cfgParse, buffer) == CFG_FAIL){
    CfgPrintError();
    CfgParseFree(cfgParse);
    return(CFG_FAIL);
  }

  free(buffer);

  CfgParseFree(cfgParse);

  printf("\n>>>>> foo <<<<<\n");

  printf("MRD : %d\n", CfgParseGetNextDec (dataType));
  printf("FF  : %g\n", CfgParseGetNextReal (dataType));
  printf("SF  : %g\n", CfgParseGetNextReal (dataType));
  printf("NS  : %d\n", CfgParseGetNextDec (dataType));
  printf("GPS1: 0x%08lx\n", CfgParseGetNextHex (dataType));
  printf("GPS2: 0x%08lx\n", CfgParseGetNextHex (dataType));
  printf("RTTE: %g\n", CfgParseGetNextReal (dataType));
  printf("TI0 : 0x%08lx\n", CfgParseGetNextHex (dataType));
  name = CfgParseGetNextString (dataType);
  printf("NAME: %s\n", name?name:"nil");

  return CfgParseGetResult (dataType);
}

/*----------------------------------------------------------------------------*/
/*- func ---------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int func(void *arg, CfgDataType_t *dataType)
{
  printf("\n>>>>> func <<<<<\n");

  printf("ADDRESS: 0x%08lx\n", CfgParseGetNextHex (dataType));

  return CfgParseGetResult (dataType);
}

/*----------------------------------------------------------------------------*/
/*- ti -----------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#if 0
int ti(void *arg, ulong address, char *mode, CfgDouble_t sf, char *type,
       CfgDouble_t freq, char *ws){
#endif
int ti (void *arg, CfgDataType_t *dataType)
{
  char *name;
  
  printf("\n>>>>> ti <<<<<\n");

  printf("ADDRESS  : 0x%08lx\n", CfgParseGetNextHex (dataType));
  name = CfgParseGetNextString (dataType);
  printf("MODE     : %s\n", name?name:"nil");
  printf("SAMP FREQ: %g\n", CfgParseGetNextReal (dataType));
  name = CfgParseGetNextString (dataType);
  printf("TYPE     : %s\n", name?name:"nil");
  printf("FREQ     : %g\n", CfgParseGetNextReal (dataType));
  name = CfgParseGetNextString (dataType);
  printf("WARMSTART: %s\n", name?name:"nil");

  return CfgParseGetResult (dataType);
}

/*----------------------------------------------------------------------------*/
/*- vaListDec ----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#if 0
int vaListDec(void *arg, int nb, ...){
#endif
int vaListDec (void *arg, CfgDataType_t *dataType)
{
  int nb;
  register int i;

  printf("\n>>>>> vaListDec <<<<<\n");

  nb = CfgParseGetNextDec (dataType);
  for(i=0; i<nb; i++){
    printf("[%2d/%2d] value: %d\n", i, nb, CfgParseGetNextDec (dataType));
  }

  return CfgParseGetResult (dataType);
}

/*----------------------------------------------------------------------------*/
/*- vaListStr ----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#if 0
int vaListStr(void *arg, int nb, ...){
#endif
int vaListStr (void *arg, CfgDataType_t *dataType)
{
  register int i;
  int nb;

  printf("\n>>>>> vaListStr <<<<<\n");

  nb = CfgParseGetNextDec (dataType);
  for(i=0; i<nb; i++){
    printf("[%2d/%2d] string: `%s'\n", i, nb, CfgParseGetNextString (dataType));
  }

  return CfgParseGetResult (dataType);
}

/*----------------------------------------------------------------------------*/
/*- vaListIdx ----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#if 0
int vaListIdx(void *arg, CfgDouble_t f, int nb, ...){
#endif
int vaListIdx(void *arg, CfgDataType_t *dataType)
{
  register int i;
  int nb;

  printf("\n>>>>> vaListIdx <<<<<\n");

  printf("f = %g\n", CfgParseGetNextReal (dataType));

  nb = CfgParseGetNextDec (dataType);
  for(i=0; i<nb; i++){
    if(i % 2){
      char *string = CfgParseGetNextString (dataType);
      printf("[%2d/%2d] string: `%s'\n", i, nb, string);
    }
    else{
      int val = CfgParseGetNextDec (dataType);
      printf("[%2d/%2d] value: %d\n", i, nb, val);
    }
  }

  return CfgParseGetResult (dataType);
}

int real_test (void *arg, CfgDataType_t *dataType)
{
  printf("\n>>>>> real_test <<<<<\n");

  printf("Integer = %i\n", CfgParseGetNextDec (dataType));
  printf("String = %s\n", CfgParseGetNextString (dataType));

  return CfgParseGetResult (dataType);
}

/*----------------------------------------------------------------------------*/
/*- main ---------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int main(int argc, char *argv[]){
register int rtn = CFG_OK;
CfgParse_t   *cfgParse;
char         *buffer, *exBuffer, filename[1024];

  if((cfgParse = CfgParseNew()) == (CfgParse_t *)NULL){ exit(-1); }

  rtn |= CfgParseGetFunctionAdd(cfgParse, "REAL", real_test , NULL, 
				2, CfgDec, CfgString);

  rtn |= CfgParseGetFunctionAdd(cfgParse, "TIMING", ti, (void *)NULL, 6,
				CfgHex,
				CfgString,
				CfgReal,
				CfgString,
				CfgReal,
				CfgString);

  rtn |= CfgParseGetFunctionAdd(cfgParse, "FOO", foo, (void *)NULL, 9,
				CfgDec,
				CfgReal,
				CfgReal,
				CfgDec,
				CfgHex,
				CfgHex,
				CfgReal,
				CfgHex,
				CfgString);

  rtn |= CfgParseGetFunctionAdd(cfgParse, "BAR", bar, (void *)1, 5,
				CfgReal,
				CfgString,
				CfgReal,
				CfgHex,
				CfgDec);

  rtn |= CfgParseGetFunctionAdd(cfgParse, "BAR", bar, (void *)2, 5,
				CfgReal,
				CfgString,
				CfgReal,
				CfgHex,
				CfgDec);

  rtn |= CfgParseGetFunctionAdd(cfgParse, "BAR", bar, (void *)3, 5,
				CfgReal,
				CfgString,
				CfgReal,
				CfgHex,
				CfgDec);

  rtn |= CfgParseGetFunctionAdd(cfgParse, "FUNC", func, (void *)NULL, 1, CfgHex);


  rtn |= CfgParseGetFunctionAdd(cfgParse, "VA_LIST_IDX", (int (*)())vaListIdx,
				(void *)NULL, CFG_VA_LIST_IDX(2, 2),
				CfgReal, CfgDec, CfgString);

  rtn |= CfgParseGetFunctionAdd(cfgParse, "CHANNEL", (int (*)())channel,
				(void *)NULL, 11, CfgDec, CfgString, CfgDec,
				CfgString, CfgReal, CfgReal, CfgReal, CfgReal,
				CfgReal, CfgReal, CfgReal);

  rtn |= CfgParseGetFunctionAdd(cfgParse, "DAQ_CHANNEL", (int (*)())daqChannel,
				(void *)NULL, 3, CfgDec, CfgString, CfgReal);

  rtn |= CfgParseGetFunctionAdd(cfgParse, "VA_LIST_DEC", (int (*)())vaListDec,
				(void *)NULL, CFG_VA_LIST, CfgDec);

  rtn |= CfgParseGetFunctionAdd(cfgParse, "VA_LIST_STR", (int (*)())vaListStr,
				(void *)NULL, CFG_VA_LIST, CfgString);

  if(rtn == CFG_FAIL){
    CfgParseFree(cfgParse);
    exit(-1);
  }

  strcpy(filename, "../cfg/Func.cfg");

  if((buffer = CfgFileToBuf(filename)) == (char *)NULL){
    CfgParseFree(cfgParse);
    exit(-1);
  }

  if((exBuffer = CfgParseExtract(cfgParse, buffer, CfgFalse)) != (char *)NULL){
    printf("Extract data >>>\n%s <<<\n", exBuffer);
  }

  if(CfgParseBuffer(cfgParse, buffer) == CFG_FAIL){
    CfgPrintError();
    CfgParseFree(cfgParse);
    exit(-1);
  }

  free(buffer);
  free(exBuffer);

  CfgParseFree(cfgParse);

  exit(0);
}
