/************************************************************/
/*                                                          */
/*               Cfg Message reporter Test                  */
/*                                                          */
/*************************************************************/
/*                                                          */
/*      MODULE     : CfgMsgTest.c                           */
/*      AUTHOR     :                                        */
/*      LABORATORY : L.A.P.P.                               */
/*                                                          */
/************************************************************/
/*                                                          */
/*      MODIFICATION:                                       */
/*                                                          */
/************************************************************/
/*                                                          */
/*                                                          */
/************************************************************/

#include <CfgMsg.h>
#include <stdlib.h>
#include <stdio.h>
#include <CbfClean.h>
#include <pthread.h>
#include <unistd.h> 

static  CfgMsgR_t *msgR = NULL;;

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------- CfgPrint1 */
/*----------------------------------------------------------------------------*/
static int CfgMsgPrint1( void *p, const CfgMsg_t *msg ) {

  if( !msg ) return(CFG_FAIL);
  /*-------------------------------------------------------------------------*/
  printf("CfgMsgPrint1> %s> %s(%d)\n", CfgMsgGetLevelStr(msg),
	 CfgMsgGetTxt(msg), CfgMsgGetCount(msg));
  /*-------------------------------------------------------------------------*/
  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------- CfgPrint2 */
/*----------------------------------------------------------------------------*/
static int CfgMsgPrint2( void *p, const CfgMsg_t *msg ) {

  if( !msg ) return(CFG_FAIL);
  /*-------------------------------------------------------------------------*/
  printf("CfgMsgPrint2> %s> %s(%d)\n", CfgMsgGetLevelStr(msg),
	 CfgMsgGetTxt(msg), CfgMsgGetCount(msg));
  /*-------------------------------------------------------------------------*/
  return(CFG_OK);
}


/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------- CfgPrint3 */
/*----------------------------------------------------------------------------*/
static int CfgMsgPrint3( void *p, const CfgMsg_t *msg ) {

  if( !msg ) return(CFG_FAIL);
  /*-------------------------------------------------------------------------*/
  printf("CfgMsgPrint3> %s> %s(%d)\n", CfgMsgGetLevelStr(msg),
	 CfgMsgGetTxt(msg), CfgMsgGetCount(msg));
  /*-------------------------------------------------------------------------*/
  return(CFG_OK);
}


/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------- CfgMsgFmt */
/*----------------------------------------------------------------------------*/
static CfgMsg_t *CfgMsgFmt( int errLvl, char *fmt, ... ) {
  va_list args;
  CfgMsg_t *msg;

  /*-------------------------------------------------------------------------*/
  va_start( args, fmt );
  msg = CfgMsgNewArgs( errLvl, fmt, args );
  va_end(args);

  /*-------------------------------------------------------------------------*/
  return(msg);
}

/*----------------------------------------------------------------------------*/
/*---------------------------------------------------------------- CfgThread */
/*----------------------------------------------------------------------------*/
void CfgThread( int *wait ) {
  int i;
  CfgMsg_t *msg;
  char txt[64];

  sprintf(txt,  "Thread_%d", *wait );
  msg = CfgMsgFmt( CFG_INFO, "CfgThread_%d> started", *wait );
  CfgMsgRAddMsgTag( msgR, msg, NULL );
  /*-------------------------------------------------------------------------*/
  for( i = 0; !CbfCleanFinished(); i++ ) {

    msg = CfgMsgFmt( CFG_INFO, "CfgThread_%d> %d", *wait, i );
    CfgMsgRAddMsgTag( msgR, msg, NULL );
    
    msg = CfgMsgFmt( CFG_WARNING, "CfgThread_%d> tag", *wait );
    CfgMsgRAddMsgTag( msgR, msg, txt );
    usleep( *wait );
  }
  msg = CfgMsgFmt( CFG_INFO, "CfgThread_%d> ended", *wait );
  CfgMsgRAddMsgTag( msgR, msg, NULL );
  /*-------------------------------------------------------------------------*/
  return;
}


/*----------------------------------------------------------------------------*/
/*---------------------------------------------------------------------- Main */
/*----------------------------------------------------------------------------*/
int main( int argc, char *argv[] ) {
  int nbMsg, i, tmo[2], rtn1, rtn2;
  CfgMsg_t *msg;
  pthread_t thread[2];

  if( argc > 1 ) nbMsg = atoi( argv[1] ); else nbMsg = 10;
  msgR = CfgMsgRNew( nbMsg );
  CfgMsgRAddFnt( msgR, CfgMsgPrint1, NULL, NULL, NULL );
  CfgMsgRAddFnt( msgR, CfgMsgPrint2, NULL, NULL, NULL );
  /*-------------------------------------------------------------------------*/
  for( i = 0; i < 7; i++ ) {
    msg = CfgMsgFmt( CFG_INFO, "Message test id %d", i );
    CfgMsgRAddMsg( msgR, msg );
  }
  
  CfgMsgRSend( msgR, NULL );

  for( i = 0; i < 5; i++ ) {
    msg = CfgMsgFmt( CFG_INFO, "Message test_tag %d", i );
    CfgMsgRAddMsgTag( msgR, msg, NULL );
    msg = CfgMsgFmt( CFG_INFO, "Message testTag1 %d", i );
    CfgMsgRAddMsgTag( msgR, msg, "TAG1" );
    /*     msg = CfgMsgFmt( CFG_INFO, "Message testTag2 %d", i ); */
    CfgMsgRAddMsgTag( msgR, msg, "TAG2" );
  }

  CfgMsgRRmFnt( msgR, CfgMsgPrint1, NULL, NULL, NULL );
  CfgMsgRSend( msgR, NULL );
  
  
  for( i = 0; i < 3; i++ ) {
    msg = CfgMsgFmt( CFG_INFO, "Message test id %d", i );
    CfgMsgRAddMsg( msgR, msg );
  }
    
  CfgMsgRRmFnt( msgR, CfgMsgPrint2, NULL, NULL, NULL );
  CfgMsgRAddFnt( msgR, CfgMsgPrint3, NULL, NULL, NULL );
  CfgMsgRSend( msgR, NULL );
 
/*   exit(EXIT_SUCCESS); */

  tmo[0] = 100000;
  tmo[1] = 400000;

  pthread_create(thread, NULL,(void *(*)(void*)) CfgThread, tmo);

  pthread_create(thread+1, NULL, (void *(*)(void*))CfgThread, tmo+1);


  for( i = 0; !CbfCleanFinished(); i++ ) {    
    sleep(1);    
    msg = CfgMsgFmt( CFG_INFO, "Main_%d", i );
    CfgMsgRSend( msgR, msg );
    CfgMsgFree(msg);
  }
  pthread_join(thread[0],(void**) &rtn1 );
  pthread_join(thread[1],(void**) &rtn2 );
  msg = CfgMsgFmt( CFG_INFO, "Main %d %d", rtn1, rtn2 );
  CfgMsgRSend( msgR, msg );
  CfgMsgFree( msg );
  /*-------------------------------------------------------------------------*/
  exit(EXIT_SUCCESS);

}
