
/************************************************************************
 *
 *                  MESSAGE REPORTER TEST
 *
 ************************************************************************
 *
 *      MODULE     : CfgMsgTest
 *      AUTHOR     : L.Fournier
 *      LABORATORY : L.A.P.P.
 *      VERSION    : v1r0
 *      DATE       : 18.5.2003
 *
 ************************************************************************
 *   MODIFICATIONS :
 *   see CfgMsgTest.c
 ************************************************************************/

#include <stdarg.h>
#include <errno.h>
#include <signal.h>
#include <pthread.h>


#if defined(OSF1)
#  include <sys/resource.h>
#elif defined(Linux)
#  include <sys/time.h>
#  include <sys/resource.h>
#endif

/**************************************************************/
#include <CmMessage.h>
#include <Su.h>
#include <ELError.h>

#include <CfgLib.h>
#include <CfgVirgo.h>

/**************************************************************/
#ifndef CFGMSGTEST_H
#define CFGMSGTEST_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**************************************************************/
/* application states */
#define MC_STATE          CfgData.state
#define MC_SUSTATE        SuGetServerState()
#define MC_RQSTATE        app->rqState
#define MC_SURQSTATE      app->suRqState

/* Cm message types */
#define MC_CM_EXIT        "Exit"
#define MC_CM_CONNECT     "Connect"
#define MC_CM_STOP        "Stop"
#define MC_CM_RESTART     "Restart"
#define MC_CM_START       "Start"
#define MC_CM_MONITOR     "Monitor"

#define VX_OK             CFG_OK
#define VX_FAIL           CFG_FAIL

/**************************************************************/
/* program state enum definition */
typedef enum {
  MC_NO_REQUEST=-1,
  MC_INIT,                  /* initialization state */
  MC_CONFIGD,               /* configuration OK - thread does not run */
  MC_MONITOR,               /* photodiode monitoring */
  MC_STAB,                  /* temperature stabilization */
  MC_SCAN,                  /* temperature scanning */
  MC_COARSE,                /* coarse control */
  MC_FINE,                  /* fine control */
  MC_GOLDEN,                /* maintain lock (golden state) */
  MC_CURR_SLOPE,            /* Peltier cell current slope */
  MC_ERROR,                 /* "error" state */
  MC_EXIT,                  /* program exit */
  MC_STATE_NUMBER           /* number of states = last state +1 */
} McState_t;

/* program states and transitions */
extern char *McStateStr[MC_STATE_NUMBER];
extern int McStates[MC_STATE_NUMBER];

/* corresponding supervisor states */
extern int suStates[];
extern char *McSuStateStr[];

/**************************************************************/
/* main application data definition */
typedef struct McApp_s {
  /* general purpose */
  double mainTimeout;       /* main process timeout */
  int rqState;              /* internal requested state */
  int suRqState;            /* requested state from Su MUST BE SIGNED ! */
  int iniState;             /* internal requested state at program startup */
  int printData;            /* data print request */

  /* thread */
  pthread_t thread1;        /* thread definition */
  pthread_t thread2;        /* thread definition */
  int threadPriority;       /* thread priority=20 (above normal) */
  double threadTimeout;     /* thread timeout */

} McAppData_t;

/**************************************************************/
/* thread function definition s*/
typedef void *(*McThread_t)(void *);

/* transition function definitions */
typedef SuServerTransitionCondition (*McTransition_t)(McAppData_t *app);

/**************************************************************/
/* function prototypes */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
