
#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <signal.h>
#include <CmMessage.h>
#include <CfgLib.h>
#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

#define CFGOUT_UIRQINFO "UIRqInfo"

extern CfgBool_t CfgOutIsConnectionGranted(char *server);

/*----------------------------------------------------------------------------*/
/*- buildMsg -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int buildMsg(CmMessage message,  void *arg, char *consumer, char *group){

  CmMessageSetType(message, CFGOUT_UIRQINFO);

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- quitHandler --------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
void quitHandler(int signo){

  CfgOutGroupFree("UIRQINFO");
  CfgOutGroupFree("UIRQACTIVATION");
  CmMessageCloseServer("");

  exit(signo);
}

/*----------------------------------------------------------------------------*/
/*- recvHandler --------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
CmMessageStatus recvHandler(CmMessage msg, char *sender, char *server){

  printf("Receive message `%s' from %s\n", CmMessageGetType(msg), sender);

  return(CmMessageOk);
}

/*----------------------------------------------------------------------------*/
/*- main ---------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int main(int argc, char *argv[]){
CfgParse_t   *cfgParse;
char         filename[1024];
struct sigaction act;
register CfgBool_t first = CfgTrue;
char servername[256], *ptr;

  /*------------------------------------------------ Setup the signal handler */
  act.sa_handler = quitHandler;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;
  if(sigaction(SIGINT, &act, (struct sigaction *)NULL) == -1){
    perror("sigaction(SIGINT)");
    exit(EXIT_FAILURE);
  }

  if(sigaction(SIGQUIT, &act, (struct sigaction *)NULL) == -1){
    perror("sigaction(SIGQUIT)");
    exit(EXIT_FAILURE);
  }

  if(sigaction(SIGTERM, &act, (struct sigaction *)NULL) == -1){
    perror("sigaction(SIGTERM)");
    exit(EXIT_FAILURE);
  }

  if((cfgParse = CfgParseNew()) == (CfgParse_t *)NULL){ exit(EXIT_FAILURE); }

  if(CfgOutGroupNew("UIRQINFO", cfgParse, 5, 10, 2, 2) == CFG_FAIL){
    exit(EXIT_FAILURE);
  }

  if(CfgOutGroupNew("UIRQACTIVATION", cfgParse, 5, 10, 2, 2) == CFG_FAIL){
    exit(EXIT_FAILURE);
  }

  strcpy(servername, basename(argv[0]));
  if((ptr = strchr(servername, '.')) != (char *)NULL){ ptr[0] = '\0'; }

  if(!CmMessageOpenMultipleServer(servername)){
    fprintf(stderr, "Cannot initialize Cm connection\n");
    exit(EXIT_FAILURE);
  }

  CmMessageInstallHandler(recvHandler, "UIInfo");
  CmMessageInstallHandler(recvHandler, "UIActivation");

  CfgOutCmInit();

  strcat(strcpy(filename, XSTR(CFG_PATH)), "/cfg/Cl.cfg");
  
  if(CfgParseFile(cfgParse, filename) == CFG_FAIL){
    CfgPrintError();
    CfgParseFree(cfgParse);
    exit(EXIT_FAILURE);
  }
  
  CfgParseFree(cfgParse);

  CfgOutGroupConsumerAdd("UIRQINFO", "ClTestA1", -1, 10, CfgOutStatic, NULL,
                         NULL);
  CfgOutGroupConsumerAdd("UIRQACTIVATION", "ClTestA1", -1, 10, CfgOutStatic,
                         NULL, NULL);
  
  for(;;){
    if(first == CfgTrue){
      int rtn;

      rtn = CfgOutGroupConsumerRequest("UIRQINFO", "ClTestA1", buildMsg,
                                       (void *)NULL, 200e-3);
      if(rtn == CFG_FAIL){
        CfgOutStatus_t status;
        char *smsg[] = {
          "None",
          "Unknown by nameServer",
          "Connection in progress",
          "Host is unreachable",
          "Host is alive",
          "Cm message is sending",
          "Cm message is new"
        };

        status = CfgOutGroupConsumerStatusGet("UIRQINFO", "ClTestA1");

        printf("%s: status -> %s\n", basename(argv[0]), smsg[status]);
      }
      else{
        first = CfgFalse;
      }
    }
    else{
      if(!CfgOutIsConnectionGranted("ClTestA1")){ first = CfgTrue; }
    }

    CmMessageWaitWithTimeout(1.);
  }
}
