
#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>


#include <sys/socket.h>
#include <CmMessage.h>
#include <CfgLib.h>

#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

#ifdef __Lynx__
extern char *optarg;
extern int getopt(int, char *[], const char *);
#endif /* __Lynx__ */

#define CFGOUT_TEST   "CfgOutTest"
#define CFGOUT_SERVER "CfgOutServer"

extern int CfgOutCmReqCsmAdd(char *server, int retry, int priority,
                             char *group, char *sender);
extern int CfgOutCmReqCsmRemove(char *server, char *group, char *sender);
extern int CfgOutCmReqGroupAdd(char *server, char *group, char *domain);
extern int CfgOutCmReqGroupRemove(char *server, char *group, char *domain);
extern void CfgOutRegisterDisconnection(char *server);
extern CfgBool_t CfgOutIsConnectionGranted(char *server);

typedef struct root{
  int       *buffer;
  char      *group;
  char      *domain;
  int       prio;
  int       retry;
  CfgBool_t dynamic;
  int       delay;
  int       nbGroup;
} root_t;

root_t root = {(int *)NULL, (char *)NULL, (char *)NULL, 10, -1, CfgFalse, 0, 0};

void quitHandler(int sig){
register int i;

  for(i=root.nbGroup; i>0; i--){
    char group[256];

    printf("press to <CTRL> C %d times to exit...\n", root.nbGroup);

    sprintf(group, "group_%d%d", getpid(), i-1);
    CfgOutCmReqCsmRemove(CFGOUT_SERVER, group, (char *)NULL);
    root.nbGroup--;

    return;
  }

  CfgOutCmReqCsmRemove(CFGOUT_SERVER, root.group, (char *)NULL);

  if(root.group) { free(root.group); root.group = NULL; }
  if(root.domain) { free(root.domain); root.domain = NULL; }

  exit(sig);
}

CmMessageStatus recvHandler(CmMessage message, char *sender, char *server){
CmMessageArrayType type;
time_t             tm, now;
int                count, nelem;
char               *group, *domain;

  time(&now);

  tm          = CmMessageGetInt(message);
  group       = CmMessageGetText(message);
  domain      = CmMessageGetText(message);
  count       = CmMessageGetInt(message);
  root.buffer = CmMessageGetArray(message, &type, &nelem);

  printf("name              : %s\n", CmConnectGetName(CmConnectWhoAmI()));
  printf("group             : %s\n", group);
  printf("domain            : %s\n", domain);
  printf("message sent @    : %s", ctime(&tm));
  printf("message received @: %s", ctime(&now));
  printf("count             : %d\n", count);
  printf("nelem of buffer   : %d\n\n", nelem);

  return(CmMessageOk);
}

int main(int argc, char *argv[]){
register int c, i;
char servername[256], *ptr;

  CfgOutRegisterDisconnection(CFGOUT_SERVER);

  strcpy(servername, basename(argv[0]));
  if((ptr = strchr(servername, '.')) != (char *)NULL){ ptr[0] = '\0'; }

  if(!CmMessageOpenMultipleServer(servername)){
    fprintf(stderr, "Cannot initialize Cm connection\n");
    exit(EXIT_FAILURE);
  }

  while((c = getopt(argc, argv, "dg:hm:n:p:r:t:")) != -1){
    switch(c){
      case 'd':
        root.dynamic = CfgTrue;
        break;
      case 'g':
        root.group = strdup(optarg);
        break;
      case 'm':
        root.domain = strdup(optarg);
        break;
      case 'n':
        root.nbGroup = atoi(optarg);
        break;
      case 'p':
        root.prio = atoi(optarg);
        break;
      case 'r':
        root.retry = atoi(optarg);
        break;
      case 't':
        root.delay = atoi(optarg);
        break;
      case 'h':
      default:
        fprintf(stderr,
                "Usage: %s [-d] [-g <group>] [-m <domain>] [-p <priority>] "
                "[-r <retry>] [-t <delay>] [-n <# group>]\n",
                basename(argv[0]));
        exit(EXIT_FAILURE);
    }
  }

  printf("My name is %s\n", CmConnectGetName(CmConnectWhoAmI()));

  CmMessageInstallHandler(recvHandler, CFGOUT_TEST);

  if(root.dynamic == CfgTrue){
    struct sigaction act;

    /*---------------------------------------------- Setup the signal handler */
    act.sa_handler = quitHandler;
    sigemptyset(&act.sa_mask);
    act.sa_flags = 0;
    if(sigaction(SIGINT, &act, (struct sigaction *)NULL) == -1){
      perror("sigaction(SIGINT)");
      exit(EXIT_FAILURE);
    }

    if(sigaction(SIGQUIT, &act, (struct sigaction *)NULL) == -1){
      perror("sigaction(SIGQUIT)");
      exit(EXIT_FAILURE);
    }

    if(sigaction(SIGTERM, &act, (struct sigaction *)NULL) == -1){
      perror("sigaction(SIGTERM)");
      exit(EXIT_FAILURE);
    }

    if(root.group != (char *)NULL){
      CfgOutCmReqGroupAdd(CFGOUT_SERVER, root.group, (char *)NULL);
    }

    CfgOutCmReqCsmAdd(CFGOUT_SERVER,
                      root.retry,
                      root.prio,
                      root.group,
                      root.domain);

    for(i=0; i<root.nbGroup; i++){
      char group[256];

      sprintf(group, "group_%d%d", getpid(), i);

      CfgOutCmReqGroupAdd(CFGOUT_SERVER, group, (char *)NULL);
      CfgOutCmReqCsmAdd(CFGOUT_SERVER,
                        root.retry,
                        root.prio,
                        group,
                        root.domain);
    }

    usleep(500000);

    if(!CfgOutIsConnectionGranted(CFGOUT_SERVER)){
      printf("%s: Connection to %s denied\n",
             basename(argv[0]), CFGOUT_SERVER);
      exit(EXIT_FAILURE);
    }
  }

  for(;;){
    CmMessageWaitWithTimeout(10e-3);
    if(!CfgOutIsConnectionGranted(CFGOUT_SERVER)){
      if(root.dynamic == CfgTrue){
        sleep(1);
        CfgOutCmReqCsmAdd(CFGOUT_SERVER,
                          root.retry,
                          root.prio,
                          root.group,
                          root.domain);
      }
      else{
        printf("%s: Connection to %s denied\n",
               basename(argv[0]), CFGOUT_SERVER);
        exit(EXIT_FAILURE);
      }
    }

    if(root.delay){sleep(root.delay); }
  }

  exit(0);
}
