
#include <libgen.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <signal.h>
#include <CmMessage.h>
#include <CfgLib.h>
#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

#define CFGOUT_TEST "CfgOutTest"

typedef struct root{
  int          nelement;
  int          *buffer;
  char         *group;
} root_t;

static int count = 0;
root_t root[2] = {
  {0x10000, (int *)NULL, (char *)NULL},
  {0x10000, (int *)NULL, (char *)NULL},
};

/*----------------------------------------------------------------------------*/
/*- buildMsg -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int buildMsg(CmMessage message,  void *arg, char *consumer, char *group){
root_t *rootp = arg;

  CmMessageSetType(message, CFGOUT_TEST);
  CmMessagePutInt(message, time((time_t *)NULL));
  CmMessagePutText(message, group);
  CmMessagePutText(message, rootp->group? rootp->group: "default");
  CmMessagePutInt(message, count);
  CmMessagePutExtArray(message, CmMessageInt, rootp->nelement, rootp->buffer);

  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
/*- quitHandler --------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
void quitHandler(int signo){

  if(root[0].buffer){ free(root[0].buffer); root[0].buffer = NULL; }
  if(root[1].buffer){ free(root[1].buffer); root[1].buffer = NULL; }

  CfgOutGroupFree(root[0].group);
  CfgOutGroupFree(root[1].group);

  CmMessageCloseServer("");

  exit(signo);
}

/*----------------------------------------------------------------------------*/
/*- main ---------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
int main(int argc, char *argv[]){
register int i;
CfgParse_t   *cfgParse;
char         filename[1024];
char         servername[256], *ptr;
struct sigaction act;

  if(argc == 3){ root[1].group = strdup(argv[2]); argc--; }
  if(argc == 2){ sscanf(argv[1], "%d", &root[0].nelement); argc--; }
  if(argc != 1){
    fprintf(stderr, "usage: %s [nelement] [group]\n",
            basename(argv[0]));
    exit(EXIT_FAILURE);
  }

  strcpy(servername,  basename(argv[0]));
  if((ptr = strchr(servername, '.')) != (char *)NULL){ ptr[0] = '\0'; }


  /*------------------------------------------------ Setup the signal handler */
  act.sa_handler = quitHandler;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;
  if(sigaction(SIGINT, &act, (struct sigaction *)NULL) == -1){
    perror("sigaction(SIGINT)");
    exit(EXIT_FAILURE);
  }

  if(sigaction(SIGQUIT, &act, (struct sigaction *)NULL) == -1){
    perror("sigaction(SIGQUIT)");
    exit(EXIT_FAILURE);
  }

  if(sigaction(SIGTERM, &act, (struct sigaction *)NULL) == -1){
    perror("sigaction(SIGTERM)");
    exit(EXIT_FAILURE);
  }

  srand(time((time_t *)NULL));

  if(!CmMessageOpenServer("CfgOutTestName")){
    fprintf(stderr, "Cannot initialize Cm connection\n");
    exit(EXIT_FAILURE);
  }

  if(!CmMessageOpenServer(servername)){
    fprintf(stderr, "Cannot initialize Cm connection\n");
    exit(EXIT_FAILURE);
  }

  CfgOutCmInit();

  if((cfgParse = CfgParseNew()) == (CfgParse_t *)NULL){ exit(EXIT_FAILURE); }

  if(CfgOutGroupNew((char *)NULL, cfgParse, 5, 10, 2, 2) == CFG_FAIL){
    exit(EXIT_FAILURE);
  }

  root[0].buffer = (int *)malloc(sizeof(int) * root[0].nelement);
  if(root[0].buffer == (int *)NULL){
    perror("malloc(1)");
    exit(EXIT_FAILURE);
  }

  for(i=0; i<root[0].nelement; i++){ root[0].buffer[i] = rand(); }

  if(root[1].group != (char *)NULL){
    if(CfgOutGroupNew(root[1].group, cfgParse, 5, 10, -1, 2) == CFG_FAIL){
      CfgParseFree(cfgParse);
      exit(EXIT_FAILURE);
    }
  
    root[1].nelement = root[0].nelement;
  
    root[1].buffer = (int *)malloc(sizeof(int) * root[1].nelement);
    if(root[1].buffer == (int *)NULL){
      perror("malloc(2)");
      exit(EXIT_FAILURE);
    }
  
    for(i=0; i<root[1].nelement; i++){ root[1].buffer[i] = rand(); }
  }

  strcat(strcpy(filename, XSTR(CFG_PATH)), "/cfg/out.cfg");
  
  if(CfgParseFile(cfgParse, filename) == CFG_FAIL){
    CfgPrintError();
    CfgParseFree(cfgParse);
    exit(EXIT_FAILURE);
  }
  
  CfgParseFree(cfgParse);
  
  for(;;){
    CfgOutGroupPost((char *)NULL, buildMsg, &root[0]);
    if(root[1].group != (char *)NULL){
      CfgOutGroupPost(root[1].group, buildMsg, &root[1]);
    }

    CmMessageWaitWithTimeout(1.);

    count++;
  }
}
