#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <CfgLib.h>
#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

int foo (void *arg, CfgDataType_t *dataType)
{
  printf("\n>>>>> "__FUNCTION__" <<<<<\n");

  printf("Integer = %i\n", CfgParseGetNextDec (dataType));
  printf("String = %s\n", CfgParseGetNextString (dataType));

  return CfgParseGetResult (dataType);
}

int main(int argc, char *argv[]){
register int rtn;
CfgParse_t   *cfgParse;
char         filename[1024];

  if((cfgParse = CfgParseNew()) == (CfgParse_t *)NULL){ exit(-1); }

  rtn = CfgParseGetFunctionAdd(cfgParse, "TEST", foo, NULL, 
			       2,CfgDec, CfgString);

  if(rtn == CFG_FAIL){
    CfgParseFree(cfgParse);
    exit(-1);
  }

  strcpy(filename, XSTR(CFG_PATH) );
  strcat(filename, "/cfg/RealTest.cfg");

  if(CfgParseFile(cfgParse, filename) == CFG_FAIL){
    CfgParseFree(cfgParse);
    exit(-1);
  }

  CfgParseFree(cfgParse);

  exit(0);
}
