
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <CfgLib.h>
#ifdef USE_MW
#include <memwatch.h>
#endif /* USE_MW */

typedef struct TiM{
  int       mrd;
  double    ff;
  double    sf;
  int       ns;
  ulong     GPS[2];
  ulong     TI[6];
  double    rtt;
  double    rtte;
  int       na;
  char      *msg;
  char      *local;
  char      config[256];
  int       prio;
  int       level;
  CfgBool_t console;
  CfgBool_t log;
} TiM_t;

TiM_t tim;

int main(int argc, char *argv[]){
CfgParse_t *cfgParse;
char  filename[1024];

  if((cfgParse = CfgParseNew()) == (CfgParse_t *)NULL){ exit(-1); }

  CfgParseAdd(cfgParse, "MRD",     1, CfgDec,         &tim.mrd);
  CfgParseAdd(cfgParse, "FF",      1, CfgReal,        &tim.ff);
  CfgParseAdd(cfgParse, "SF",      1, CfgReal,        &tim.sf);
  CfgParseAdd(cfgParse, "NS",      1, CfgDec,         &tim.ns);
  CfgParseAdd(cfgParse, "NA",      1, CfgDec,         &tim.na);
  CfgParseAdd(cfgParse, "CONSOLE", 1, CfgFlag,        &tim.console);
  CfgParseAdd(cfgParse, "LOG",     1, CfgFlag,        &tim.log);

  if(argc > 1){
    CfgParseAdd(cfgParse, "TI0",     4, CfgHex,         &tim.TI[0],
                                        CfgConstString, &tim.config[0],
                                        CfgString,      &tim.msg,
                                        CfgString,      &tim.local);
    CfgParseAdd(cfgParse, "TI",      1, CfgHex,         &tim.TI[1]);
    CfgParseAdd(cfgParse, "TI",      1, CfgHex,         &tim.TI[2]);
    CfgParseAdd(cfgParse, "TI",      1, CfgHex,         &tim.TI[3]);
    CfgParseAdd(cfgParse, "TI",      1, CfgHex,         &tim.TI[4]);
    CfgParseAdd(cfgParse, "TI",      1, CfgHex,         &tim.TI[5]);
    CfgParseAdd(cfgParse, "GPS",     1, CfgHex,         &tim.GPS[0]);
    CfgParseAdd(cfgParse, "GPS",     1, CfgHex,         &tim.GPS[1]);
    CfgParseAdd(cfgParse, "RTT",     1, CfgReal,        &tim.rtt);
    CfgParseAdd(cfgParse, "RTTE",    1, CfgReal,        &tim.rtte);

    CfgParseArg(cfgParse, argc, argv);
  }
  else{
    char *buffer, *config;

    strcpy(filename, XSTR(CFG_PATH));
    strcat(filename, "/cfg/Test.cfg");


    printf("%s: read file \"%s\"\n", argv[0], filename);

    if((buffer = CfgFileToBuf(filename)) == (char *)NULL){
      CfgParseFree(cfgParse);
      exit(-1);
    }

    printf("\n\t\t\t----------- BUFFER ------------\n");
    printf("%s\n", buffer);
    printf("\t\t\t-------------------------------\n");

    config = CfgParseExtract(cfgParse, buffer, CfgFalse);
    if(config == (char *)NULL){
      CfgPrintError();
      CfgParseFree(cfgParse);
      exit(-1);
    }

    printf("\n\t\t\t---------- EXTRACTED ----------\n");
    printf("%s\n", config);
    printf("\t\t\t-------------------------------\n");

    free(config);

    CfgParseAdd(cfgParse, "TI0",     4, CfgHex,         &tim.TI[0],
                                        CfgConstString, &tim.config[0],
                                        CfgString,      &tim.msg,
                                        CfgString,      &tim.local);
    CfgParseAdd(cfgParse, "TI",      1, CfgHex,         &tim.TI[1]);
    CfgParseAdd(cfgParse, "TI",      1, CfgHex,         &tim.TI[2]);
    CfgParseAdd(cfgParse, "TI",      1, CfgHex,         &tim.TI[3]);
    CfgParseAdd(cfgParse, "TI",      1, CfgHex,         &tim.TI[4]);
    CfgParseAdd(cfgParse, "TI",      1, CfgHex,         &tim.TI[5]);

    if(CfgParseBuffer(cfgParse, buffer) == CFG_FAIL){
      CfgPrintError();
      CfgParseFree(cfgParse);
      exit(-1);
    }

    if(tim.msg != (char *)NULL){ free(tim.msg); }
    if(tim.local != (char *)NULL){ free(tim.local); }

    CfgParseAdd(cfgParse, "GPS",     1, CfgHex,         &tim.GPS[0]);
    CfgParseAdd(cfgParse, "GPS",     1, CfgHex,         &tim.GPS[1]);
    CfgParseAdd(cfgParse, "RTT",     1, CfgReal,        &tim.rtt);
    CfgParseAdd(cfgParse, "RTTE",    1, CfgReal,        &tim.rtte);

    if(CfgParseBuffer(cfgParse, buffer) == CFG_FAIL){
      CfgPrintError();
      CfgParseFree(cfgParse);
      exit(-1);
    }

    free(buffer);
  }

  printf("MRD    : %d\n", tim.mrd);
  printf("FF     : %g\n", tim.ff);
  printf("SF     : %g\n", tim.sf);
  printf("NS     : %d\n", tim.ns);
  printf("RTT    : %g\n", tim.rtt);
  printf("RTTE   : %g\n", tim.rtte);
  printf("NA     : %d\n", tim.na);
  printf("CONSOLE: %s\n", tim.console?"present":"absent");
  printf("LOG    : %s\n\n", tim.log?"present":"absent");
  printf("GPS1   : 0x%08lx\n", tim.GPS[0]);
  printf("GPS2   : 0x%08lx\n", tim.GPS[1]);
  printf("RTT    : %g\n", tim.rtt);
  printf("RTTE   : %g\n\n", tim.rtte);
  printf("TI0    : 0x%08lx\n", tim.TI[0]);
  printf("       : config : %s\n", tim.config);
  printf("       : message: %s\n", tim.msg?tim.msg:"nil");
  printf("       : local  : %s\n", tim.local?tim.local:"nil");
  printf("TI1    : 0x%08lx\n", tim.TI[1]);
  printf("TI2    : 0x%08lx\n", tim.TI[2]);
  printf("TI3    : 0x%08lx\n", tim.TI[3]);
  printf("TI4    : 0x%08lx\n", tim.TI[4]);
  printf("TI5    : 0x%08lx\n", tim.TI[5]);


  CfgParseFree(cfgParse);

  if(tim.msg != (char *)NULL){ free(tim.msg); }
  if(tim.local != (char *)NULL){ free(tim.local); }

  exit(0);
}
