
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <sched.h>
#include <CfgVirgo.h>
#include <pthread.h>
#include <unistd.h> 

int CfgStateSet( char * );

/*----------------------------------------------------------------------------*/
int CfgStateSet( char *state ) {
  /*--------------------------------------------------------------------------*/
  CfgMsgAddInfo("CfgStateSet> %s", state ?  state : "Undedined");
  /*--------------------------------------------------------------------------*/
  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
void CfgThread0( void ) {
  unsigned int loop;
  cpu_set_t cpuset;
  char *tmp;
  int i, nb;

  sched_getaffinity( 0, sizeof cpuset, &cpuset );
  nb =  CPU_COUNT( &cpuset ); 
  tmp = CfgStrFmtCat( NULL, CfgFalse, "CPU affinity nb %d - ", nb );
  for( i = 0; i < CPU_SETSIZE; i++ ) { 
    if( CPU_ISSET( i, &cpuset ) ) tmp = CfgStrFmtCat( tmp, CfgFalse, "%d,", i );
  }
  CfgMsgAddInfo("CfgThread0> started - %s", tmp );
  if( tmp ) free(tmp );
  /*--------------------------------------------------------------------------*/
  for( loop = 0; !CfgFinished(); loop++ ) {
    CfgMsgAddFmtTag( CFG_INFO, 0, "CfgTread0", "CfgThread0> loop %u", loop );
    usleep( 101 );
    /* usleep(509); ----------------------------------------- 1./509 = 1992.03 */
    /* if( loop%644 == 0 ) CfgMsgAddInfo("CfgThread0> loop %u", loop ); */
  }
  CfgMsgAddInfo("CfgThread0> ended");
  /*--------------------------------------------------------------------------*/
  return;
}


/*----------------------------------------------------------------------------*/
void CfgThread1( void ) {
  unsigned int loop;
  cpu_set_t cpuset;
  char *tmp;
  int i, nb;

  sched_getaffinity( 0, sizeof cpuset, &cpuset );
  nb =  CPU_COUNT( &cpuset ); 
  tmp = CfgStrFmtCat( NULL, CfgFalse, "CPU affinity nb %d - ", nb );
  for( i = 0; i < CPU_SETSIZE; i++ ) { 
    if( CPU_ISSET( i, &cpuset ) ) tmp = CfgStrFmtCat( tmp, CfgFalse, "%d,", i );
  }
  CfgMsgAddInfo("CfgThread1> started - %s", tmp );
  if( tmp ) free(tmp );
  /*--------------------------------------------------------------------------*/
  for( loop = 0; !CfgFinished(); loop++ ) {
    CfgMsgAddFmtTag( CFG_INFO, 0, "CfgTread1", "CfgThread1> loop %u", loop );
/*    usleep( 152 );  */
    CfgMsgAddFmtTag( CFG_INFO, 0, "CfgTread1-2", "CfgThread1> mix %u", loop );
    /* usleep(23677); ----------------------------------- 1./23677e-6 = 42.23 */
    if( loop%100000 == 0 ) CfgMsgAddWarning("CfgThread1> loop %u", loop ); 
  }
  CfgMsgAddInfo("CfgThread1> ended");
  /*--------------------------------------------------------------------------*/
  return;
}


/*----------------------------------------------------------------------------*/
void CfgThread2( void ) {
  unsigned int loop;
  cpu_set_t cpuset;
  char *tmp;
  int i, nb;

  sched_getaffinity( 0, sizeof cpuset, &cpuset );
  nb =  CPU_COUNT( &cpuset ); 
  tmp = CfgStrFmtCat( NULL, CfgFalse, "CPU affinity nb %d - ", nb );
  for( i = 0; i < CPU_SETSIZE; i++ ) { 
    if( CPU_ISSET( i, &cpuset ) ) tmp = CfgStrFmtCat( tmp, CfgFalse, "%d,", i );
  }
  CfgMsgAddInfo("CfgThread2> started - %s", tmp );
  if( tmp ) free(tmp );
  /*--------------------------------------------------------------------------*/
  for( loop = 0; !CfgFinished(); loop++ ) {
    CfgMsgAddFmtTag( CFG_INFO, 0, "CfgTread2", "CfgThread2> loop %u", loop );
    usleep( 253 );
    CfgMsgAddFmtTag( CFG_INFO, 0, "CfgTread1-2", "CfgThread2> mix %u", loop );
    /* usleep(3779); --------------------------------------- 1/3779e-6 = 264.6 */
/*    if( loop%1320 == 0 )  { */
/*      CfgMsgAddError("CfgThread2> loop %u", loop ); */
/*       break; */
/*    } */
  }
  CfgMsgAddInfo("CfgThread2> ended");
  /*--------------------------------------------------------------------------*/
  return;
}


/*----------------------------------------------------------------------------*/
void CfgVirgoExit( void ) {
  CfgMsgAddInfo("CfgVirgoExit> call");
}

/*----------------------------------------------------------------------------*/
/* char *CfgVirgoState( int state ) { */
/*   return(CfgServerStateStrGet()); */
/* } */

/*----------------------------------------------------------------------------*/
int main( int argc, char *argv[] ) {
  char liveTime[50];
  int i, lMsg, rtn;
  size_t size;
  char *config, *buf;
  pthread_t thread[3];

  char *line=NULL;
  size_t len;
  int cnt;

#ifdef USE_MW
  mwStatistics( 2 );
#endif
/*   if (CfgVirgoId); */


  if( argc == 4 ) { lMsg = atoi( argv[2]  ); argc--; }
  else lMsg = 1;
  printf("Press enter to continue\n");
  cnt = getline( &line, &len, stdin );
  if( cnt >= 0 ) printf("getline: %d bytes : '%s'\n", cnt, line);
  if( line ) { free(line); line = NULL;} 

  /*--------------------- Initialize Cm and Error Report ..., load the config */

  if( CfgIdle( argc, argv, lMsg ) == CFG_FAIL) exit(EXIT_FAILURE);

  printf("Press enter to continue\n");
  cnt = getline( &line, &len, stdin );
  if( cnt >= 0 ) printf("getline: %d bytes : '%s'\n", cnt, line);
  if( line ) { free(line); line = NULL;} 

  CbfCleanSetExitFnt( CfgVirgoExit );
  CfgMsgAddInfo("Main> MailBox length %d", lMsg );
/*   CfgSetStateFnt( CfgServerIdle, CfgServerConfigured, */
/* 		  (CfgStateReachFnt_t)CfgStateSet, "IdleToConfigured" ); */
/*   CfgSetStateFnt( CfgServerConfigured, CfgServerActive, */
/* 		  (CfgStateReachFnt_t)CfgStateSet, "ConfiguredToActive" ); */
  CfgSetStateFnt( CfgServerIdle, CfgServerActive, 
		  (CfgStateReachFnt_t)CfgStateSet, "IdleToActive" );
  /*---------------- Define the function which define the server state string */
/*   CfgSetStateStrFnt(CfgVirgoState); */

  /*---------------------------------------------------Take the configuration */
  if( !(config = CfgGetConfig()) ) 
    CfgMsgAddFmt(CFG_FATAL, 0, "Config unknown" );
  printf("config> %s\n", config );
  
  /*---------------------------------------------------- Performs the parsing */
  CfgReachState( CfgServerConfigured ); 

#ifndef RIO806X
  pthread_create( &thread[0], NULL, (void *(*)(void*))CfgThread0, NULL );
  pthread_create( &thread[1], NULL, (void *(*)(void*))CfgThread1, NULL );
  pthread_create( &thread[2], NULL, (void *(*)(void*))CfgThread2, NULL );
#endif

  CfgReachState( CfgServerActive );
  
  CfgMsgSendWithTimeout(1.0);
  CfgLogFPrint( "Here> %s\n", CfgGetConfig() ? CfgGetConfig() : "NONE");

  CfgMsgPrintInfo("CfgMsgPrintInfo Call");
  CfgMsgPrintWarning("CfgMsgPrintWarning call");
 

  for( buf = NULL, size = rand()%1024, i = 0; !CfgFinished() ; i++ ) {
 
   /*-------------------------------------------- Flush the message reporter */
    CfgMsgAddInfo("Main> Before CmMsgSendWithTimeout - %d", i );
    CfgMsgSendWithTimeout(1);
    CfgMsgAddInfo("Main> After CmMsgSendWithTimeout - %d", i );
    CfgMsgAddFmt( CFG_INFO, 1, "Debug message" ); 
/*     if( i%10 == 0 )  */
/*       CfgMsgAddInfo("confTag %s - dbName %s", CfgData, */
/*                     (CfgData.dbName ? CfgData.dbName : "NONE") ); */
    /*------------------------------------------------------- Active Su State */
    CfgMsgAddUserInfo( "Active %s - size %f(KB)- %d",  
		       CfgRunTimeStr( liveTime, sizeof liveTime),  size/1024., i);

    if( (buf = (char*)realloc( buf, size )) ) size *= 2;
    if( !(i%21) ) size = rand()%1024 ;
    if( !i%4 ) CfgMsgAddError("from main - %d", i);
/*     if( i == 5 ) CfgMsgAddFatal("from main - %d", i); */
/*     if( i == 10 ) CfgTerminate(); */

  }
  if( buf ) { free(buf); buf = NULL; }

#ifndef RIO806X
  rtn = pthread_join( thread[0], NULL );
  if( rtn ) CfgMsgAddWarning("Main> pthread_join thread[0] failed - rtn %d", rtn);
  rtn = pthread_join( thread[1], NULL );
  if( rtn ) CfgMsgAddWarning("Main> pthread_join thread[1] failed - rtn %d", rtn);
  rtn =pthread_join( thread[2], NULL );
  if( rtn ) CfgMsgAddWarning("Main> pthread_join thread[2] failed - rtn %d", rtn);
#endif
  CfgMsgAddInfo("After pthread_join - Before exit");
/*   CfgMsgSendWithTimeout( 1.); */
  exit(EXIT_SUCCESS);
}

