
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <sched.h>
#include <CfgVirgo.h>
#include <pthread.h>
#include <unistd.h> 



/*----------------------------------------------------------------------------*/
int main( int argc, char *argv[] ) {
  char *config;
  CfgParse_t *cfgParse;
  /*--------------------- Initialize Cm and Error Report ..., load the config */

  if( CfgIdle( argc, argv, 1 ) == CFG_FAIL) exit(EXIT_FAILURE);

 
  /*---------------------------------------------------Take the configuration */
  if( !(config = CfgGetConfig()) ) 
    CfgMsgAddFmt(CFG_FATAL, 0, "MAIN> Config unknown" );

   if( !(cfgParse = CfgParseNew()) ) {
    CfgMsgAddFatal( "MAIN> CfgParseNew or AcEngNew failed" );
    return(CFG_FAIL);
  }
 
  /*---------------------------------------------------- Performs the parsing */
  CfgReachState( CfgServerConfigured ); 

  CfgParseBuffer( cfgParse, config );
  cfgParse = CfgParseFree( cfgParse );

  CfgReachState( CfgServerActive );
  
  CfgMsgSendWithTimeout(0);
  CfgLogFPrint( "Here> %s\n", CfgGetConfig() ? CfgGetConfig() : "NONE");

  exit(EXIT_SUCCESS);
}

