
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <CfgVirgo.h>

static long int Tag = 0;
static char buf[2048];
static int Fatal = 0;

/*----------------------------------------------------------------------------*/
static CmMessageStatus CfgFatal( CmMessage message, char *sender,
					char *serverName ) {
  Fatal = 1;
  return(CmMessageBreak );
}

/*----------------------------------------------------------------------------*/
static CmMessageStatus CfgError( CmMessage message, char *sender,

					char *serverName ) {
  CfgMsgAddInfo("CfgError> by %s", sender);
  CfgReachState( CfgServerError);
  return(CmMessageBreak );
}


/*----------------------------------------------------------------------------*/
void CfgVirgoTtExit( void ) {
  CfgMsgAddInfo( "CfgVirgoExit\n");
}


/*----------------------------------------------------------------------------*/
int *CfgVirgoTtDone(int *arg) {
  char fName[50];
  sprintf( fName, "Function%ld",  (long int)arg);
  if( !CbfCleanFind( fName, arg ) ) return(NULL);

  CbfCleanDone( fName, arg );
  CfgMsgAddFmt(CFG_INFO, 1, "CfgVirgoTtDone: %s", fName );
  return(NULL);
}


/*----------------------------------------------------------------------------*/
static int CfgVirgoTransition( void ){
  int i;
  char fName[50];

  /*--------------------------------------------------------------------------*/
  if( CfgGetRequestedState() == CfgServerConfigured ) {
    /*---------------------------------------- Load the default configuration */
    if( !CfgConfigLoad(NULL) ) {
      CfgMsgSendWithTimeout(0.1);
      exit(EXIT_FAILURE);
    }
  }

 switch( (int)CfgGetRequestedState() ){
 case 1:  Tag = 0;                           /*-------------------- Configure */
    break;
 case 2:  Tag = 10;                          /*----------------------- Active */
    break;
  case 3:  Tag = 100;                        /*----------------------- Golden */
    break;
  default: Tag = 1000;
    break;

  }
  /*--------------------------------------------------------------------------*/
  for( i = 0; i < (rand()%10 + 1); i++ ) {
    sprintf( fName, "Function%ld", Tag);
    CbfCleanAddRoot( fName, (CbfCleanFnt_t)CfgVirgoTtDone, (void*)Tag );
    Tag++;
    CfgMsgAddFmt( CFG_INFO, 1, "CfgVirgoTransition to %d: %s",
		  CfgGetRequestedState(), fName );
  }
  CfgMsgAddInfo("CfgVirgoTransition> tag %ld", Tag );
  return(CFG_OK);
}

/*----------------------------------------------------------------------------*/
char *CfgVirgoTtState( int state ) {
  return("CfgVirgoTtState");
}

/*----------------------------------------------------------------------------*/
int main( int argc, char *argv[] ) {
  char liveTime[50];
  int i;
  char *txt, *txt1;

#ifdef USE_MW
  mwStatistics( 2 );
#endif

  CfgMsgAddInfo("Before Cfg");
  CfgMsgAddWarning("Before Cfg");
  CfgMsgAddError("Before Cfg");

  if( CfgIdle( argc, argv, 1 ) == CFG_FAIL) exit(EXIT_FAILURE);

  CmMessageInstallHandler( CfgFatal, "CfgFatal" );
  CmMessageInstallHandler( CfgError, "CfgError" );
  CmMessageTraceOn(0);
  CbfCleanSetExitFnt( CfgVirgoTtExit );
  CfgSetDebug( 0 );
  CfgSetRFlag( -1, -1, 0 );
/*   CfgSetStateStrFnt(CfgVirgoTtState); */

  txt = CfgStrFmtCat( NULL, CfgTrue, "%s ", "Test1 Test2 Test3" );
  CfgMsgAddInfo( "StrFmtCat> %s ", txt);
  txt = CfgStrFmtCat( txt, CfgTrue, "%s", "Test1" );
  CfgMsgAddInfo( "StrFmtCat> Add Test1, %s", txt );
  txt = CfgStrFmtCat( txt, CfgTrue, "%s ", "Test2" );
  CfgMsgAddInfo( "StrFmtCat> Add Test2, %s", txt );
  txt = CfgStrFmtCat( txt, CfgTrue, "%s ", "Test3" );
  CfgMsgAddInfo( "StrFmtCat> Add Test3, %s", txt );

  txt1 = txt;
  txt = CfgStrFmtCat( NULL, CfgTrue, "%s ", "Test3");
  CfgMsgAddInfo( "StrFmtCat> %s", txt);
  txt = CfgStrFmtCat( txt, CfgTrue, "%s ", txt1);
  CfgMsgAddInfo( "StrFmtCat> %s", txt );
  txt = CfgStrRemove( txt, "Test2", ' ' );
  CfgMsgAddInfo( "StrRemove> Test2: \"%s\"", txt );
  txt = CfgStrRemove( txt, "Test1", ' ' );
  CfgMsgAddInfo( "StrRemove> Test1: \"%s\"", txt );
  txt = CfgStrRemove( txt, "Test3", ' ' );
  CfgMsgAddInfo( "StrRemove> Test3: \"%s\"", txt );

  txt = CfgStrFmtCat( txt, CfgTrue, "%s ", "BPG400MTN BPG400MTS PrLaser");
  CfgMsgAddInfo( "StrRemove>\"%s\"", txt );
  txt = CfgStrRemove( txt, "BPG400MTN", ' ' );
  CfgMsgAddInfo( "StrRemove> BPG400MTN: \"%s\"", txt );
  

  free( txt ); free( txt1);
  CfgMsgSendWithTimeout(0.1);

  CfgSetStateFnt( CfgServerIdle, CfgServerConfigured, 
		  (CfgStateReachFnt_t)CfgVirgoTransition, NULL );
  CfgSetStateFnt( CfgServerConfigured, CfgServerActive,
		  (CfgStateReachFnt_t)CfgVirgoTransition, NULL );
  CfgSetStateFnt( CfgServerActive, CfgServerGolden, 
		  (CfgStateReachFnt_t)CfgVirgoTransition, NULL );
  
  CfgReachState(CfgServerConfigured);
  CfgReachState(CfgServerActive);
  CfgReachState(CfgServerGolden);
  CfgMsgPrintInfo("Print Info call" );

  memset( buf, 'a', sizeof buf); buf[sizeof buf -1] = '\0';
  buf[ sizeof buf / 2 ] = '\n';

  for( i = 0; !CfgFinished(); i++ ) {
    /*-------------------------------------------- Flush the message reporter */
    if( !(i%10) ) CfgMsgSendWithTimeout(0.1);
    CfgMsgAddFmtTag( CFG_INFO, 0, "Test", "%03d Test-%s", i,
		  CfgRunTimeStr(liveTime, 50));
    /*------------------------------ Su State: Idle, Configure, Active or End */
    CfgGetState();

    if( !(i%1000) ) CfgReachState( CfgServerActive );
    if( !(i%100) ) {
      CfgReachState( CfgServerGolden );
      CfgMsgAddInfo( "Buffer %s\n", buf );
    }

    /*------------------------------------------------------- Active Su State */
    if( !(i%10) ) CfgMsgAddUserInfo( "Active-%s - USER_INFO - %d ",
				     CfgRunTimeStr(liveTime, 50),
				     (int)(pow(10, rand()%10 )) );
    if( Fatal ) CfgMsgAddFmt( CFG_FATAL, 0, "Fatal Error" );
  }

  CfgMsgAddInfo("After main loop - Before exit");
  exit(EXIT_SUCCESS);
}

