
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <CfgVirgo.h>

static char buf[2048];

/*----------------------------------------------------------------------------*/
void CfgVirgoTtExit( void ) {
  CfgMsgAddInfo( "CfgVirgoExit");
}


/*----------------------------------------------------------------------------*/
int *CfgVirgoTtDone(int *arg) {
  char fName[50];
  sprintf( fName, "Function%ld",  (long int)arg);
  if( !CbfCleanFind( fName, arg ) ) return(NULL);

  CbfCleanDone( fName, arg );
  CfgMsgAddFmt(CFG_INFO, 1, "CfgVirgoTtDone: %s", fName );
  return(NULL);
}


/*----------------------------------------------------------------------------*/
char *CfgVirgoTtState( int state ) {
  return("CfgVirgoTtState");
}

/*----------------------------------------------------------------------------*/
int main( int argc, char *argv[] ) {
  char liveTime[50];
  int i;
  char *txt, *txt1;

#ifdef USE_MW
  mwStatistics( 2 );
#endif


  if( CfgIdle( argc, argv, 256 ) == CFG_FAIL) exit(EXIT_FAILURE);

  CbfCleanSetExitFnt( CfgVirgoTtExit );
  CfgSetDebug( 0 );
  CfgSetRFlag( -1, -1, 0 );
/*   CfgSetStateStrFnt(CfgVirgoTtState); */

  txt = CfgStrFmtCat( NULL, CfgTrue, "%s ", "Test1 Test2 Test3" );
  CfgMsgAddInfo( "StrFmtCat> %s ", txt);
  txt = CfgStrFmtCat( txt, CfgTrue, "%s", "Test1" );
  CfgMsgAddInfo( "StrFmtCat> Add Test1, %s", txt );
  txt = CfgStrFmtCat( txt, CfgTrue, "%s ", "Test2" );
  CfgMsgAddInfo( "StrFmtCat> Add Test2, %s", txt );
  txt = CfgStrFmtCat( txt, CfgTrue, "%s ", "Test3" );
  CfgMsgAddInfo( "StrFmtCat> Add Test3, %s", txt );

  txt1 = txt;
  txt = CfgStrFmtCat( NULL, CfgTrue, "%s ", "Test3");
  CfgMsgAddInfo( "StrFmtCat> %s", txt);
  txt = CfgStrFmtCat( txt, CfgTrue, "%s ", txt1);
  CfgMsgAddInfo( "StrFmtCat> %s", txt );

  free( txt ); free( txt1);
  CfgMsgSendWithTimeout(0.1);
  i = CfgFinished();
  CfgMsgPrintInfo("Print Info call - CfgFinished %d", i );

  memset( buf, 'a', sizeof buf); buf[sizeof buf -1] = '\0';
  buf[ sizeof buf / 2 ] = '\n';

  for( i = 0; !CfgFinished(); i++ ) {
    if( i && !(i%20) ) CfgTerminate(); 
    /*-------------------------------------------- Flush the message reporter */
    if( !(i%10) ) CfgMsgSendWithTimeout(1.0);
    CfgMsgAddFmtTag( CFG_INFO, 0, "Test", "Test-%s", CfgRunTimeStr(liveTime, 50));
    if( !(i%100) ) CfgMsgAddInfo( "Buffer %s\n", buf );
   
    /*------------------------------------------------------- Active Su State */
    if( !(i%10) ) CfgMsgAddUserInfo( "Active-%s - USER_INFO",
             CfgRunTimeStr(liveTime, 50));
/*     if( !i ) CfgMsgAddFmt( CFG_FATAL, 0, NULL,  "Fatal Error" ); */
  }

  CfgMsgAddInfo("After main loop - Before exit");
  exit(EXIT_SUCCESS);
}

