#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <CfgVirgo.h>
/* #include <glib.h> */

#define N_ITEMS 12

static int fatal = 0;

/* CmMessageStatus */
/* _get_web_ui_data_cmd (CmMessage message, char *sender, char *server_name) */
/* { */
/* 	char *data; */
/* 	gsize size; */

/* 	CmMessage answer; */

/* 	answer = CmMessageNew (); */
/* 	CmMessageSetType (answer, "GetWebUIDataAck"); */
/* 	g_file_get_contents (DUMMY_PROCESS_WEB_UI_HTML, &data, &size, NULL); */
/* 	data = g_realloc (data, size + 1); */
/* 	data[size] = '\0'; */
/* 	CmMessagePutText (answer, data); */
/* 	g_file_get_contents (DUMMY_PROCESS_WEB_UI_JS, &data, &size, NULL); */
/* 	data = g_realloc (data, size + 1); */
/* 	data[size] = '\0'; */
/* 	CmMessagePutText (answer, data); */

/* 	if (!CmMessageSend (answer, sender)) */
/* 		g_warning ("[DummyProcess::_get_web_ui_data_cmd] Can't not send user interface data"); */

/* 	CmMessageDelete (answer); */

/* 	return CmMessageOk; */
/* } */

/* CmMessageStatus */
/* _get_items_cmd (CmMessage message, char *sender, char *server_name) */
/* { */
/* 	CmMessage answer; */
/* 	int i; */

/* 	answer = CmMessageNew (); */
/* 	CmMessageSetType (answer, "GetItemsAck"); */

/* 	for (i = 0; i < N_ITEMS; i++) { */
/* 		char *string = g_strdup_printf ("Item%d", i); */
/* 		CmMessagePutText (answer, string); */
/* 		g_free (string); */
/* 	} */

/* 	if (!CmMessageSend (answer, sender)) */
/* 		g_warning ("[DummyProcess::_get_item_cmd] Can't send item list"); */

/* 	CmMessageDelete (answer); */

/* 	return CmMessageOk; */
/* } */

static CmMessageStatus
_reload_config_handler (CmMessage message, char *sender, char *server)
{
	CfgMsgAddInfo ("reloadConfig message received from %s\n", sender);

	return CmMessageBreak;
}

static CmMessageStatus
_set_values_handler (CmMessage message, char *sender, char *server)
{
	CfgMsgAddInfo ("setValues message received from %s\n", sender);

	if (CmMessageGetItemType (message) != CmMessageItemInt) {
		CfgMsgAddError ("val0 not received");
		return CmMessageBreak;
	}
	CfgMsgAddInfo ("val0 = %d", CmMessageGetInt (message));

	if (CmMessageGetItemType (message) != CmMessageItemInt) {
		CfgMsgAddError ("val1 not received");
		return CmMessageBreak;
	}
	CfgMsgAddInfo ("val1 = %d", CmMessageGetInt (message));

	if (CmMessageGetItemType (message) != CmMessageItemText) {
		CfgMsgAddError ("val2 not received");
		return CmMessageBreak;
	}
	CfgMsgAddInfo ("val2 = %s", CmMessageGetText (message));

	if (CmMessageGetItemType (message) != CmMessageItemDouble) {
		CfgMsgAddError ("val3 not received");
		return CmMessageBreak;
	}
	CfgMsgAddInfo ("val3 = %g", CmMessageGetDouble (message));

	CfgMsgAddInfo ("Message completely received");

	return CmMessageBreak;
}

static CmMessageStatus
_question_handler (CmMessage message, char *sender, char *server)
{
	CmMessage answer;

	sleep (5);

	answer = CmMessageNew ();
	CmMessageSetType (answer, "Answer");
	CmMessagePutText (answer, "Hello world!");
	CmMessagePutInt (answer, 42);

	CmMessageSend (answer, sender);

	CmMessageDelete (answer);

	return CmMessageBreak;
}

static int mute = 0;

static CmMessageStatus
_toggle_mute_handler (CmMessage message, char *sender, char *server)
{
	if (mute == 0) {
		mute = 1;
		CfgMsgAddInfo ("Mute on");
	} else {
		mute = 0;
		CfgMsgAddInfo ("Mute off");
	}

	return CmMessageBreak;
}

static CmMessageStatus
_fatal_handler (CmMessage message, char *sender, char *server)
{
	fatal = 1;

	return CmMessageBreak;
}

int
main (int argc, char **argv)
{
	int count = 0;

	printf ("Start application\n");
	fflush(stdout);

	CfgIdle (argc, argv, 128);

/* 	CmMessageInstallHandler (_get_web_ui_data_cmd, "GetWebUIDataCmd"); */
/* 	CmMessageInstallHandler (_get_items_cmd, "GetItemsCmd"); */

	CmMessageInstallHandler (_reload_config_handler, "reloadConfig");
	CmMessageInstallHandler (_set_values_handler, "setValues");
	CmMessageInstallHandler (_toggle_mute_handler, "toggleMute");
	CmMessageInstallHandler (_question_handler, "Question");
	CmMessageInstallHandler (_fatal_handler, "Fatal");

	CfgReachState (CfgServerIdle);
	CfgReachState (CfgServerConfigured);
	CfgReachState (CfgServerActive);
	CfgReachState (CfgServerGolden);

	while (!CfgFinished ()) {
		if ((count + 15) % 15 == 0)
			CfgMsgAddInfo ("Info at %d", count);
		if ((count + 10) % 15 == 0)
			CfgMsgAddWarning ("Warning at %d", count);
		if ((count + 5) % 15 == 0)
			CfgMsgAddError ("Error at %d", count);

		if (fatal)
			CfgMsgAddFatal ("Fatal at %d", count);

		if (!mute)
			CfgMsgAddUserInfo ("count:%d - Lorem ipsum dolor sit amet, consectetur adipisicing elit, "
					   "sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", count++);
		else
			count++;

		if( count == 45 ) CfgMsgAddFatal( "from main, %d", count );

		CfgMsgSendWithTimeout (1.0);
	}

	sleep (5);

	printf ("Stop application\n");

	return EXIT_SUCCESS;
}
