#include <stdio.h>
#include <Ci.h>
#include <OKit.h>
#include <OWidget.h>

#include <CmMessage.h>

Widget XtWidgetTop ();
int OXtDispatchEvent (XEvent*);
void CmSwitch ();

  /* A Cm handler */
void MyHandler (CmMessage message, char* name, char* serverName);

  /* An OnX callback */
void SendMessage (char* to, char* text);

int main (int argc, char** argv)
{
  if (!CmMessageOpenServer ("Toto")) return (0);
  
    /* Declares the Cm handler */
  CmMessageInstallDefaultHandler (MyHandler);
  
    /* Install Cm in the C interpretor */
  CiPathNew ("CMSRC");
  CiBindClass ("CmSwitch",     (CiRoutine) CmSwitch);
  
    /* Declares the OnX callback */
  CiDo ("void SendMessage (char* to, char* text);");
  CiFunctionBind ("SendMessage", (CiRoutine) SendMessage);
  
    /* OnX is initialized */
  OKitInitClass (argc, argv);
  
    /* Install the Onx dispatcher inside Cm */
  {      
    Display* display;
    Widget w;
    
    w = XtWidgetTop ();
    display = XtDisplay (w);
    CmOnxSetup (display, OXtDispatchEvent);
  }
  
    /*
      The CmMessageWait function is substituted to
      the usual OKitMainLoop function.
      */
  
  CmMessageWait ();
  
  OKitClearClass   ();
}

void MyHandler (CmMessage message, char* name, char* serverName)
{
  char* text;
  
  text = CmMessageGetText (message);
  printf ("Received from %s : %s.\n", Name, text);
}

void SendMessage (char* to, char* text)
{
  static CmMessage message = 0;
  
  if (!message) message = CmMessageNew ();
  
  CmMessageReset (message);
  CmMessagePutText (message, text);
  if (!CmMessageSend (message, to))
    {
      printf ("Error sending message to %s\n", to);
    }
}

