#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define HISTORY_SIZE 100

static char history[HISTORY_SIZE][256];
static int history_read = 0;
static int history_write = 0;
static int history_items = 0;
static int has_history = 0;

/*----------------------------------------------------*/
static void history_setup ()
/*----------------------------------------------------*/
{
  static int initialized = 0;

  if (!initialized)
    {
      int i;

      initialized = 1;

      has_history = getenv ("HAS_HISTORY") != NULL;

      history_read = 0;
      history_write = 0;
      history_items = 0;

      for (i = 0; i < HISTORY_SIZE; i++)
        {
          history[i][0] = 0;
        }
    }
}

/*----------------------------------------------------*/
static void history_push (const char* format, ...)
/*----------------------------------------------------*/
{
  char* line;
  char* time;
  va_list args;

  history_setup ();

  if (!has_history) return;

  va_start (args, format);

  line = &history[history_write][0];

  time = CmConnectTime ();

  strcpy (line, "H>");
  line += strlen (line);
  strcpy (line, time + 4);
  line += strlen (line) - 5;
  strcpy (line, "> ");
  line += strlen (line);

  vsprintf (line, format, args);

  va_end (args);

  history_write++;
  if (history_write >= HISTORY_SIZE) history_write = 0;
  if (history_items < HISTORY_SIZE) history_items++;
}

/*----------------------------------------------------*/
static char* history_pop ()
/*----------------------------------------------------*/
{
  char* line;

  history_setup ();

  if (!has_history) return (NULL);

  if (history_items == 0) return (NULL);

  history_read = history_write - history_items;
  if (history_read < 0) history_read += HISTORY_SIZE;

  line = &history[history_read][0];

  history_items--;

  return (line);
}


