/*----------------------------------------------------------------------*/
#include <stdlib.h>
#include "FrameL.h"

typedef struct FdCList FdCList;    

struct FdCList {    /* channel list structure                                */
  long gps_ms;      /* gps time in ms for the last update                    */
  int nSorted;      /* number of sorted element in the list                  */
  int nChnl;        /* current number of channel in the list                 */
  int maxChnl;      /* maximum number of channel the list could hold         */
  int **chnl;       /* list of channels with GPS time, sampling rate and name
                       The GPS time is stored first as an long (to align the name),
                       Then the sampling rate is stored as a double,
                       Then the channel name */
  int nDuplicated;  /* number of duplicated channel */
  char firstDup[512];/* name of thefirst duplicated channel */
};

FdCList* FdCListNew();
int      FdCListBuildAdc (FdCList* list, FrameH *frame, int gpsLimit);
int      FdCListBuildSer (FdCList* list, FrameH *frame, int gpsLimit);
int      FdCListBuildSim (FdCList* list, FrameH *frame, int gpsLimit);
int      FdCListBuildProc(FdCList* list, FrameH *frame, int gpsLimit);
char*    FdCListDump (FdCList* list);
void     FdCListFree (FdCList *list);
FdCList* FdCListMerge(FdCList *l1, FdCList *l2, FdCList *l3, FdCList *l4);

