/*****************************************************************************/
/*  FdFrMrgr.c    Contains the frame merger code                             */
/*****************************************************************************/

#if !defined(FDFRMRGR_DEFINED)
#define FDFRMRGR_DEFINED DONE

#include <CfgVirgo.h>
#include <CfgParse.h>
#include "FrameL.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct FdFrMrgr FdFrMrgr;

struct FdFrMrgr          /* for the frame merger                          */
{
  char*     sList;       /* input tag */
  int       nFrames;     /* buffer size */
  int       debug;       /* debug level. 1 give some extra debug*/
  int       nSources;    /* number of expected sources */
  int       nMissing;    /* number of missing sources*/
  double    lastGpsOut;  /* GPS time of the last frame outputed */
  char**    sNames;      /* list of input sources */
  FrameH**  frames;      /* list of frame pointers   */
  double*   gps;         /* list of GPS time */
  FRBOOL*   missingSt;   /* tell if a frame source is missing or not*/
  FRBOOL*   missingPr;   /* tell if the missing source info has been printed*/
  double*   latencies;   /* array of latencies; size nFrames.nSources */
  char*     missingSrc;  /* list of missing sources */
  char*     serData;     /* buffer for the serData */
  int       serDataSize; /* size of serData buffer*/
  int       nOuts;       /* number of frames produced */
  char*     status;      /* string with the status information*/
};


void      FdFrMrgrAddSource(FdFrMrgr* frMrgr, char* newSource);
FdFrMrgr* FdFrMrgrNew(int nFrames, char* sList);
FrameH*   FdFrMrgrProc(FdFrMrgr* mrgr, FrameH* frameIn, char* sender);
void      FdFrMrgrRemoveSource(FdFrMrgr* frMrgr, char* newSource);
#ifdef __cplusplus
}
#endif

#endif
