/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
#ifndef __CmConnect__
#define __CmConnect__

#include <stdarg.h>
#include <CSet.h>
#include <Cvt.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _CmConnectRec* CmConnect;
typedef struct _CmConnectIteratorRec* CmConnectIterator;

typedef enum
{
  CmConnectStatusNoData = 0,
  CmConnectStatusData,
  CmConnectStatusDelayed,
  CmConnectStatusAbort
} CmConnectStatus;

typedef enum
{
  CmConnectNormalCompletion,
  CmConnectNoHandler,
  CmConnectTimeoutDetection,
  CmConnectBreakDetection,
  CmConnectErrorCondition
} CmConnectCondition;

typedef enum
{
  CmErrorBadPort = 1,
  CmErrorBadName,
  CmErrorBadHost,
  CmErrorNoNameServer,
  CmErrorBadSocket,
  CmErrorBadEnvironment,
  CmErrorBadMemory,
  CmErrorRecovered
} CmErrorCode;

typedef struct _CmNameServerInfosRec* CmNameServerInfos;
typedef struct _CmNameServerInfosRec
{
  char* name;
  char* host;
  int   port;
  int   firstPort;
  int   ports;
  char* repository;
} CmNameServerInfosRec;

typedef struct _CmConnectStatisticsRec* CmConnectStatistics;
typedef struct _CmConnectStatisticsRec
{
  int sent;
  int received;
  int bytes_sent;
  int bytes_received;
} CmConnectStatisticsRec;

typedef int (*CmConnectPrinter) (char* format, va_list args);

typedef void (*CmConnectFunction) ();
typedef void (*CmConnectConnectionHandler) (CmConnect);
typedef CmConnectStatus (*CmConnectReceiveHandler) (CmConnect);
typedef CmConnectStatus (*CmConnectRearmHandler) (CmConnect);
typedef int (*CmConnectBuildPortHandler) (void);

#define CmConnectInstallBuildPortHandler CmConnectInstallBPHandler
#define CmConnectInstallDisconnectionHandler CmConnectInstallDHandler
#define CmConnectInstallConnectionHandler CmConnectInstallCHandler
#define CmConnectStartupAsMultipleServer CmConnectStartupAsMS

void CmConnectForceStartup  ();
void CmConnectInitialize  ();
void CmConnectCleanup  ();
void CmConnectCheckBalance  ();
CmConnectPrinter CmConnectInstallPrinter  (CmConnectPrinter printer);
char* CmConnectGetDomain  ();
void CmConnectSetDomain  (char* name);
void CmConnectExit  (CmErrorCode error);
CmConnectConnectionHandler CmConnectInstallConnectionHandler  (    CmConnectConnectionHandler function);
CmConnectConnectionHandler CmConnectInstallDisconnectionHandler  (    CmConnectConnectionHandler function);
void CmConnectDebugOn  ();
void CmConnectDebugOff  ();
char* CmConnectTime  ();
CmConnect CmConnectStartupAsServer  (char* name);
CmConnect CmConnectStartupAsMultipleServer  (char* name);
CmConnect CmConnectOpenServer  (char* name);
CmConnect CmConnectOpenMultipleServer  (char* name);
void CmConnectCloseServer  (char* name);
CmConnect CmConnectSelectServer  (char* name);
void CmServerSetComment  (char* comment);
char* CmServerGetComment  ();
CmConnect CmConnectWhoAmI  ();
CmConnect CmConnectNew  (char* name);
CmConnect CmConnectNewWithAddress  (CmConnect server,                                   char* name, int port, char* host);
CmConnect CmConnectNewWithSocket  (char* name, int socket_id);
int CmConnectGetSocketId  (CmConnect connect);
CmMessage CmConnectGetMessage  (CmConnect connect);
void CmConnectPushMessage  (CmConnect connect);
CmMessage CmConnectTopMessage  (CmConnect connect);
CmMessage CmConnectPopMessage  (CmConnect connect);
int CmConnectIsNameServer  (CmConnect connect);
int CmConnectReceive  (CmConnect connect, char* message, int length);
int CmConnectSend  (CmConnect connect, char* message, int length);
CmConnect CmConnectGetReference  (char* name);
CmConnect CmConnectGetNthReference  (char* name, int number);
char* CmConnectGetName  (CmConnect connect);
CmConnect CmConnectGetServer  (CmConnect connect);
CmConnect CmConnectGetNameServer  ();
void CmConnectSetName  (CmConnect connect, char* newName);
int CmConnectIsLocal  (CmConnect connect);
int CmConnectIsMultiple  (CmConnect connect);
void CmConnectSetMultiple  (CmConnect connect);
void CmConnectSetPort  (CmConnect connect, int port);
int CmConnectSnprint ( CmConnect c, char *txt, int size );
void CmConnectSetSocketSize  ( int snd, int rcv, char *tName );
int CmConnectGetPort  (CmConnect connect);
char* CmConnectGetHost  (CmConnect connect);
void CmConnectSetHost  (CmConnect connect, char* host_name);
char* CmConnectGetOwner  (CmConnect connect);
void CmConnectSetOwner  (CmConnect connect, char* owner);
CmConnectIterator CmConnectGetIterator  ();
void CmConnectIteratorDelete  (CmConnectIterator it);
CmConnect CmConnectGetNextAlive  (CmConnectIterator it);
CmConnect CmConnectGetNext  (CmConnectIterator it);
CmConnect CmConnectScan  (CmConnectIterator it);
void CmConnectInstallReceiveHandler  (CmConnect connect,                                     CmConnectReceiveHandler receive);
void CmConnectInstallRearmHandler  (CmConnect connect,                                   CmConnectRearmHandler rearm);
void CmConnectInitData  (CmConnect connect,                        CmConnectReceiveHandler receive,                        CmConnectRearmHandler rearm);
void CmConnectInitHandlers  (CmConnect connect,                            CmConnectReceiveHandler receive,                            CmConnectRearmHandler rearm);
void CmConnectInstallMessage  (CmConnect connect, CmMessage message);
void CmConnectInstallMessageIterator  (CmConnect connect,                                      CmMessageIterator it);
void CmConnectInstallNoTimeOut  (CmConnect connect);
void CmConnectInstallTimeOut  (CmConnect connect, int Seconds, int MicroSeconds);
void CmConnectKill  (CmConnect connect);
char* CmConnectGetComment  (CmConnect connect);
void CmConnectGetStatistics  (CmConnect connect,                              CmConnectStatisticsRec* buffer);
CmConnectCondition CmConnectCheck  ();
CmConnectCondition CmConnectWait  ();
CmConnectCondition CmConnectWaitOnIterator  (CmMessageIterator it);
CmConnectCondition CmConnectWaitWithTimeout  (double seconds);
CmConnectStatus CmConnectCheckInputData  (CmConnect connect);
CmNameServerInfos CmNameServerGetInfos  ();
int CmConnectTestPort  (int port);

#ifdef __cplusplus
}
#endif

#endif
