/*----------------------------------------------------------------------*/
#include <stdlib.h>
#include "FdChList.h"

#define CfgMsgAddFatal printf

/*---------------------------------------------------------------------------*/
int main(int argc, char *argv[])  
/*---------------------------------------------------------------------------*/
{
  FrFile *iFile;
  FrameH *frame;
  FdCList *list1, *list2, *listM;

  iFile = FrFileINew("/data/rawdata/v140/V-raw-1048515000-1000.gwf");
  //iFile = FrFileINew("/data/procdata/bufferv6/V1Online_NoInjChnl//V-V1Online_NoInjChnl-1048676000-4000.gwf");
 iFile = FrFileINew("test.gwf");

  frame = FrameRead(iFile);
//  FrameTag(frame,"*a*");
  list1 = FdCListBuildAdc(frame);

  printf("ADC: \n%s\n",FdCListDump(list1));

  list1 = FdCListBuildProc(frame);
  printf("PROC: \n%s\n",FdCListDump(list1));

  list2 = FdCListBuildSer(frame);
  printf("SER:\n%s\n",FdCListDump(list2));

  list2 = FdCListBuildSim(frame);
  printf("SIM:\n%s\n",FdCListDump(list2));

  frame = FrameRead(iFile);
  FrameTag(frame,"*a*");
  list2 = FdCListBuildAdc(frame);
  printf("Next frame---------------\nADC\n%s\n",FdCListDump(list2));

  listM = FdCListMerge(list2, list1, frame->GTimeS - 11);
  printf("MERGED:\n%s\n",FdCListDump(listM));

  return(0);
}
 
