/*----------------------------------------------------------------------------*/
/*  FdIOServer.c                                                              */
/* This is the basic application to read and write frames with the Fd library.*/
/* The actions are defined in the configuration file passed as argument.      */
/*----------------------------------------------------------------------------*/

#include <FdIO.h>

/*------------------------------------------------------------- main ---------*/
int main(int argc, char *argv[])
/*------------------------------------------------------------- main ---------*/
{
  FrameH *frame;
  FdIO *fdIO;

  fdIO = FdIONew(argc, argv);  /*--------create the FdIO object; IDLE state---*/

  FdIOParseAndIni(fdIO);      /*---------parse configuration and initialize---*/

  CfgReachState(CfgServerGolden);
  fdIO->autoState = CfgTrue;  /*---to update program state at get/put frame---*/

  while (!CfgFinished()) {    /*----------------------------------main loop---*/

    frame = FdIOGetFrame(fdIO); 
    if (frame == NULL) continue;

    if(fdIO->userInfo == NULL) {
      CfgMsgAddUserInfo("%d-%d latency %.2f", frame->GTimeS,
                        ((int)frame->dt), FrameLatency(frame));
      CfgMsgSendWithTimeout(0.0001);}

    FdIOPutFrame(fdIO, frame);}

  return(0);
}
