/*----------------------------------------------------------------------------*/
/*  This test program retreive the list of channels from a remote Cm process. */
/*  Program argument: the Cm name of the remote process.                      */
/*----------------------------------------------------------------------------*/

#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include "FdUtil.h"

FrFile *Ofile = NULL;
char   *Source, *Tag, *Path;
char    MyName[256];
int     tStart = 0;
int     TotTime;
int     FileLen;

/*----------------------------------------------------------------------------*/
void End (int s)
/*----------------------------------------------------------------------------*/
{
  printf("Disconnect and close file(%d)\n", s);

  FdRemoveFramesRequest(Source, MyName);

  FrFileOEnd(Ofile);

  exit(0);
}
/*----------------------------------------------------------------------------*/
CmMessageStatus FrameHandler (CmMessage message, char* sender, char* serverName)
/*----------------------------------------------------------------------------*/
{
  FrameH *frame;
  int nBytes;

  frame = FdGetFrameFromMessage (message, -1, &nBytes);

  if(frame == NULL) exit(0);
  printf("Frame %d received nBytes=%d\n",frame->GTimeS, nBytes);

  if(tStart == 0) {
    tStart = frame->GTimeS;
    Ofile = FrFileONewM(Path, 9, "FdWrite", FileLen);}

  FrameWrite(frame, Ofile);
  FrameFree(frame);

  if(TotTime > 0 && frame->GTimeS+frame->dt >= tStart + TotTime) End(0);

  return(CmMessageOk);
}
/*----------------------------------------------------------------------------*/
int main(int argc, char *argv[])  
/*----------------------------------------------------------------------------*/
{
  struct sigaction sigIntHandler;
  int irc;

  if (argc != 6) {
    printf("\n  You need to provide 5 argument: \n"
           "  - the Cm name of the remote process\n"
	   "  - the channels selection\n"
	   "  - the total time the program must run\n"
	   "  - the local file prefix\n"
	   "  - the duration of the frame files in seconds\n"
	   " example: FdWrite MainDy \"*\" 1000 V1:Test 100\n");
    return(0);}

  Source  = argv[1];
  Tag     = argv[2];
  TotTime = atoi(argv[3]);
  Path    = argv[4];
  FileLen = atoi(argv[5]);

  /*-----------------------------------create a name likely to be unique---*/
  CmMessageOpenMultipleServer ("FdWrite");
  sprintf(MyName, "%s", CmConnectGetName  (CmConnectWhoAmI ()));

  printf("We will ask %d seconds of data to %s with the tag %s\n",
	 TotTime, Source, Tag);
  printf(" local file will be %d seconds long and will start with %s\n",
	 FileLen, Path);
 
  CmMessageInstallHandler (FrameHandler, "FdFrame");

  /*------------------------the next four lines are to catch the ctrl-C---*/
  sigIntHandler.sa_handler = End;
  sigemptyset(&sigIntHandler.sa_mask);
  sigIntHandler.sa_flags = 0;
  sigaction(SIGINT, &sigIntHandler, NULL);

  /*--------------request frames to the source without an output queue---*/
  irc = FdRequestFrames (Source, MyName, Tag, 0, 1);
  if(irc == 0) {
    printf("Could not contact the frame source: %s\n",Source);
    exit(0);}

  CmMessageWait ();

  return(0);
}

